#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.add_kqi_input import AddKqiInput


# fmt: off
QUERY: List[str] = ["""
mutation addKqi($input: AddKqiInput!) {
  addKqi(input: $input) {
    id
    name
    description
    formula
    startDateTime
    endDateTime
    kqiCategory {
      id
    }
    kqiPerspective {
      id
    }
    kqiSource {
      id
    }
    kqiTemporalFrequency {
      id
    }
  }
}
"""
]


class addKqi:
    @dataclass(frozen=True)
    class addKqiData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class Kqi(DataClassJsonMixin):
            @dataclass(frozen=True)
            class KqiCategory(DataClassJsonMixin):
                id: str

            @dataclass(frozen=True)
            class KqiPerspective(DataClassJsonMixin):
                id: str

            @dataclass(frozen=True)
            class KqiSource(DataClassJsonMixin):
                id: str

            @dataclass(frozen=True)
            class KqiTemporalFrequency(DataClassJsonMixin):
                id: str

            id: str
            name: str
            description: str
            formula: str
            startDateTime: datetime = _field(metadata=config(encoder=custom_scalars["Time"].encoder, decoder=custom_scalars["Time"].decoder, mm_field=custom_scalars["Time"].mm_field))
            endDateTime: datetime = _field(metadata=config(encoder=custom_scalars["Time"].encoder, decoder=custom_scalars["Time"].decoder, mm_field=custom_scalars["Time"].mm_field))
            kqiCategory: KqiCategory
            kqiPerspective: KqiPerspective
            kqiSource: KqiSource
            kqiTemporalFrequency: KqiTemporalFrequency

        addKqi: Kqi

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: AddKqiInput) -> addKqiData.Kqi:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.addKqiData.from_dict(response_text)
        return res.addKqi

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: AddKqiInput) -> addKqiData.Kqi:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.addKqiData.from_dict(response_text)
        return res.addKqi
