# Generated by Django 4.1.5 on 2023-01-17 13:35

from django.db import migrations, models
import django.db.models.deletion
import taggit.managers

# fix module
# import utilities.json
import django.core.serializers.json


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        # ('tenancy', '0009_standardize_description_comments'),
        ('contenttypes', '0002_remove_content_type_name')  # ,
        # ('extras', '0084_staging'),
    ]

    operations = [
        migrations.CreateModel(
            name='PTAppSystem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('name', models.CharField(max_length=200)),
                ('slug', models.SlugField(max_length=100, unique=True)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('comments', models.TextField(blank=True)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                ('tenant', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='ptappsystem', to='tenancy.tenant')),
            ],
            options={
                'verbose_name_plural': 'Application systems',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='PTUEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('name', models.CharField(max_length=250, unique=True)),
                ('description', models.CharField(blank=True, max_length=500)),
                ('comments', models.TextField(blank=True)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name_plural': 'Unacceptable events',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='PTUEventRelation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.CharField(blank=True, max_length=500)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name_plural': 'Event relationship',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='PTUEventAssignment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('object_id', models.PositiveBigIntegerField()),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
                ('ptuevent', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='ptuevent_assignments', to='ptuevents.ptuevent')),
                ('relation', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='ptuevent_assignments', to='ptuevents.ptueventrelation')),
            ],
            options={
                'ordering': ['ptuevent'],
                'unique_together': {('content_type', 'object_id', 'ptuevent', 'relation')},
            },
        ),
        migrations.CreateModel(
            name='PTAppSystemAssignment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('object_id', models.PositiveBigIntegerField()),
                ('app_system', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='ptappsystem_assignments', to='ptuevents.ptappsystem')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
            ],
            options={
                'ordering': ['app_system'],
                'unique_together': {('content_type', 'object_id', 'app_system')},
            },
        ),
        migrations.CreateModel(
                name='PTUsers',
                fields=[
                    ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                    ('created', models.DateTimeField(auto_now_add=True, null=True)),
                    ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                    ('custom_field_data', models.JSONField(blank=True, default=dict,
                                                           encoder=django.core.serializers.json.DjangoJSONEncoder)),
                    ('name', models.CharField(max_length=250, unique=False)),

                    ('firstname', models.CharField(max_length=250, blank=True)),
                    ('lastname', models.CharField(max_length=250, blank=True)),
                    ('status', models.CharField(max_length=250, unique=False, blank=True, default='enabled')),
                    ('sAMAccountName', models.CharField(max_length=250, unique=True, blank=False)),
                    ('ad_guid', models.CharField(max_length=250, blank=True)),
                    ('vpnIPaddress', models.CharField(max_length=250, blank=True)),
                    ('ad_description', models.CharField(max_length=250, blank=True)),
                    ('position', models.CharField(max_length=250, blank=True)),
                    ('department', models.CharField(max_length=250, blank=True)),
                    ('comment', models.CharField(max_length=250, blank=True)),

                    ('description', models.CharField(blank=True, max_length=500)),
                    ('comments', models.TextField(blank=True)),
                ],
                options={
                    'ordering': ['name'],
                },
        ),
        migrations.CreateModel(
                name='PTWorkstations',
                fields=[
                    ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                    ('created', models.DateTimeField(auto_now_add=True, null=True)),
                    ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                    ('custom_field_data', models.JSONField(blank=True, default=dict,
                                                           encoder=django.core.serializers.json.DjangoJSONEncoder)),
                    ('name', models.CharField(max_length=100, unique=True)),
                    ('CN', models.CharField(max_length=250, unique=True)),
                    ('DistinguishedName', models.CharField(max_length=500, unique=True)),
                    ('ad_guid', models.CharField(max_length=250, unique=True)),
                    ('ad_description', models.CharField(max_length=500, unique=True)),
                    ('description', models.CharField(blank=True, max_length=500)),
                ],
                options={
                    'ordering': ['name'],
                },
        )
    ]
