import { Construct } from '@aws-cdk/core';
import { SecretKey } from '@cloudcomponents/cdk-secret-key';
export interface GithubWebhookProps {
    /**
     * The OAuth access token.
     */
    readonly githubApiToken: string | SecretKey;
    /**
     * The Github repo url.
     */
    readonly githubRepoUrl: string;
    /**
     * The URL to which the payloads will be delivered.
     */
    readonly payloadUrl: string;
    /**
     * Determines what events the hook is triggered for.
     *
     * @see https://developer.github.com/v3/activity/events/types/
     */
    readonly events: string[];
    readonly logLevel?: 'debug' | 'info' | 'warning' | 'error';
}
export declare class GithubWebhook extends Construct {
    constructor(scope: Construct, id: string, props: GithubWebhookProps);
}
