import json
import os
from time import sleep

from apollo_orm.domains.models.entities.concurrent.result_list.entity import ResultList
from apollo_orm.domains.models.entities.connection_config.entity import ConnectionConfig
from apollo_orm.domains.models.entities.credentials.entity import Credentials
from apollo_orm.orm.core import ORMInstance


def test_work_flow():
    credential = {"hosts": ["cn-beleza-scylla01.hml.naturacloud.com", "cn-beleza-scylla02.hml.naturacloud.com",
                            "cn-beleza-scylla03.hml.naturacloud.com"], "port": 9042, "user": "206114060",
                  "password": "Natura_123", "keyspace_name": "mastercadastro"}
    json_data = json.loads(os.environ['JSON_DATA'])
    json_data = json.loads(json.dumps({
        "company": 1,
        "country": 1,
        "business_model": 1,
        "structure_level": 5,
        "structure_code": 25970,
        "operational_cycle": 202401,
        "version": 1,
        "actives": 0,
        "memory_detail": "{ \"_id\" : { \"$oid\" : \"654ebd9a56ed11aa74ccbbaa\" }, \"rewardCode\" : 8, \"version\" : 12, \"country\" : 1, \"businessModel\" : 1, \"structureLevel\" : 2, \"structureCode\" : 6, \"structureName\" : \"CENTRO OESTE\", \"updateUserCode\" : \"NOT_FOUND\", \"updateUserName\" : \"Larissa Nair Oliveira De Souza\", \"cycle\" : 202317, \"customIndexes\" : [], \"bonuses\" : [{ \"active\" : false, \"growthPlanCode\" : 2, \"planName\" : \"Plano Natura - Líder de Negócio\", \"leaderLevelCode\" : 8, \"leaderLevelName\" : \"Líder Prata\", \"_id\" : { \"$oid\" : \"654ebd9a56ed113d2bccbbad\" }, \"rows\" : [] }, { \"active\" : false, \"growthPlanCode\" : 2, \"planName\" : \"Plano Natura - Líder de Negócio\", \"leaderLevelCode\" : 9, \"leaderLevelName\" : \"Líder Ouro\", \"_id\" : { \"$oid\" : \"654ebd9a56ed112472ccbbac\" }, \"rows\" : [] }, { \"active\" : false, \"growthPlanCode\" : 2, \"planName\" : \"Plano Natura - Líder de Negócio\", \"leaderLevelCode\" : 10, \"leaderLevelName\" : \"Líder Diamante\", \"_id\" : { \"$oid\" : \"654ebd9a56ed118073ccbbab\" }, \"rows\" : [] }], \"matrices\" : [{ \"active\" : true, \"growthPlanCode\" : 2, \"planName\" : \"Plano Natura - Líder de Negócio\", \"leaderLevelCode\" : 8, \"leaderLevelName\" : \"Líder Prata\", \"parameterRowType\" : 28, \"parameterColumnType\" : 424, \"_id\" : { \"$oid\" : \"654ebd9a56ed112462ccbbc2\" }, \"columns\" : [{ \"column\" : 1, \"rangeBegin\" : 0, \"rangeEnd\" : 999, \"_id\" : { \"$oid\" : \"654ebd9a56ed113796ccbbc3\" }, \"rows\" : [{ \"row\" : 1, \"rangeBegin\" : 0, \"rangeEnd\" : 89.99, \"value\" : 5.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed112b60ccbbcb\" } }, { \"row\" : 2, \"rangeBegin\" : 90, \"rangeEnd\" : 94.99, \"value\" : 6.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed111124ccbbca\" } }, { \"row\" : 3, \"rangeBegin\" : 95, \"rangeEnd\" : 99.99, \"value\" : 7.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed1171b1ccbbc9\" } }, { \"row\" : 4, \"rangeBegin\" : 100, \"rangeEnd\" : 104.99, \"value\" : 10.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed1126baccbbc8\" } }, { \"row\" : 5, \"rangeBegin\" : 105, \"rangeEnd\" : 109.99, \"value\" : 13.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed11ca0dccbbc7\" } }, { \"row\" : 6, \"rangeBegin\" : 110, \"rangeEnd\" : 114.99, \"value\" : 14.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed119908ccbbc6\" } }, { \"row\" : 7, \"rangeBegin\" : 115, \"rangeEnd\" : 119.99, \"value\" : 16, \"_id\" : { \"$oid\" : \"654ebd9a56ed111b95ccbbc5\" } }, { \"row\" : 8, \"rangeBegin\" : 120, \"rangeEnd\" : 999.99, \"value\" : 17.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed110663ccbbc4\" } }] }] }, { \"active\" : true, \"growthPlanCode\" : 2, \"planName\" : \"Plano Natura - Líder de Negócio\", \"leaderLevelCode\" : 9, \"leaderLevelName\" : \"Líder Ouro\", \"parameterRowType\" : 28, \"parameterColumnType\" : 424, \"_id\" : { \"$oid\" : \"654ebd9a56ed116596ccbbb8\" }, \"columns\" : [{ \"column\" : 1, \"rangeBegin\" : 0, \"rangeEnd\" : 999, \"_id\" : { \"$oid\" : \"654ebd9a56ed114c8fccbbb9\" }, \"rows\" : [{ \"row\" : 1, \"rangeBegin\" : 0, \"rangeEnd\" : 89.99, \"value\" : 6, \"_id\" : { \"$oid\" : \"654ebd9a56ed119feaccbbc1\" } }, { \"row\" : 2, \"rangeBegin\" : 90, \"rangeEnd\" : 94.99, \"value\" : 7, \"_id\" : { \"$oid\" : \"654ebd9a56ed11d321ccbbc0\" } }, { \"row\" : 3, \"rangeBegin\" : 95, \"rangeEnd\" : 99.99, \"value\" : 8, \"_id\" : { \"$oid\" : \"654ebd9a56ed111444ccbbbf\" } }, { \"row\" : 4, \"rangeBegin\" : 100, \"rangeEnd\" : 104.99, \"value\" : 11.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed1171f2ccbbbe\" } }, { \"row\" : 5, \"rangeBegin\" : 105, \"rangeEnd\" : 109.99, \"value\" : 14.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed11960bccbbbd\" } }, { \"row\" : 6, \"rangeBegin\" : 110, \"rangeEnd\" : 114.99, \"value\" : 15.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed11cd3fccbbbc\" } }, { \"row\" : 7, \"rangeBegin\" : 115, \"rangeEnd\" : 119.99, \"value\" : 17.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed117962ccbbbb\" } }, { \"row\" : 8, \"rangeBegin\" : 120, \"rangeEnd\" : 999.99, \"value\" : 19.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed111e53ccbbba\" } }] }] }, { \"active\" : true, \"growthPlanCode\" : 2, \"planName\" : \"Plano Natura - Líder de Negócio\", \"leaderLevelCode\" : 10, \"leaderLevelName\" : \"Líder Diamante\", \"parameterRowType\" : 28, \"parameterColumnType\" : 424, \"_id\" : { \"$oid\" : \"654ebd9a56ed111edbccbbae\" }, \"columns\" : [{ \"column\" : 1, \"rangeBegin\" : 0, \"rangeEnd\" : 999, \"_id\" : { \"$oid\" : \"654ebd9a56ed1137feccbbaf\" }, \"rows\" : [{ \"row\" : 1, \"rangeBegin\" : 0, \"rangeEnd\" : 89.99, \"value\" : 6.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed115da8ccbbb7\" } }, { \"row\" : 2, \"rangeBegin\" : 90, \"rangeEnd\" : 94.99, \"value\" : 7.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed11bba8ccbbb6\" } }, { \"row\" : 3, \"rangeBegin\" : 95, \"rangeEnd\" : 99.99, \"value\" : 8.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed112144ccbbb5\" } }, { \"row\" : 4, \"rangeBegin\" : 100, \"rangeEnd\" : 104.99, \"value\" : 13, \"_id\" : { \"$oid\" : \"654ebd9a56ed11f48eccbbb4\" } }, { \"row\" : 5, \"rangeBegin\" : 105, \"rangeEnd\" : 109.99, \"value\" : 16, \"_id\" : { \"$oid\" : \"654ebd9a56ed115d3accbbb3\" } }, { \"row\" : 6, \"rangeBegin\" : 110, \"rangeEnd\" : 114.99, \"value\" : 17, \"_id\" : { \"$oid\" : \"654ebd9a56ed115a4dccbbb2\" } }, { \"row\" : 7, \"rangeBegin\" : 115, \"rangeEnd\" : 119.99, \"value\" : 19.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed113fabccbbb1\" } }, { \"row\" : 8, \"rangeBegin\" : 120, \"rangeEnd\" : 999.99, \"value\" : 22, \"_id\" : { \"$oid\" : \"654ebd9a56ed1110f7ccbbb0\" } }] }] }], \"updated\" : { \"$date\" : 1699659162297 }, \"__v\" : 0 }",
        "parent_structure_code": 7009,
        "parent_structure_level": 4,
        "payment_id": 1985602,
        "published_at": "2024-03-27T18:53:58.652Z",
        "published_by": "192746898",
        "published_by_name": "Vinícius Loreto Ferreira",
        "responsible_code": 158883969,
        "responsible_name": "KELBIA DA SILVA MANZAN",
        "status": 5,
        "total_value": 2093.66,
        "cycle": 202401,
        "parent_version": 1,
        "active_persons_value": 0,
        "parameter_representation": "{ \"_id\" : { \"$oid\" : \"654ebd9a56ed11aa74ccbbaa\" }, \"rewardCode\" : 8, \"version\" : 12, \"country\" : 1, \"businessModel\" : 1, \"structureLevel\" : 2, \"structureCode\" : 6, \"structureName\" : \"CENTRO OESTE\", \"updateUserCode\" : \"NOT_FOUND\", \"updateUserName\" : \"Larissa Nair Oliveira De Souza\", \"cycle\" : 202317, \"customIndexes\" : [], \"bonuses\" : [{ \"active\" : false, \"growthPlanCode\" : 2, \"planName\" : \"Plano Natura - Líder de Negócio\", \"leaderLevelCode\" : 8, \"leaderLevelName\" : \"Líder Prata\", \"_id\" : { \"$oid\" : \"654ebd9a56ed113d2bccbbad\" }, \"rows\" : [] }, { \"active\" : false, \"growthPlanCode\" : 2, \"planName\" : \"Plano Natura - Líder de Negócio\", \"leaderLevelCode\" : 9, \"leaderLevelName\" : \"Líder Ouro\", \"_id\" : { \"$oid\" : \"654ebd9a56ed112472ccbbac\" }, \"rows\" : [] }, { \"active\" : false, \"growthPlanCode\" : 2, \"planName\" : \"Plano Natura - Líder de Negócio\", \"leaderLevelCode\" : 10, \"leaderLevelName\" : \"Líder Diamante\", \"_id\" : { \"$oid\" : \"654ebd9a56ed118073ccbbab\" }, \"rows\" : [] }], \"matrices\" : [{ \"active\" : true, \"growthPlanCode\" : 2, \"planName\" : \"Plano Natura - Líder de Negócio\", \"leaderLevelCode\" : 8, \"leaderLevelName\" : \"Líder Prata\", \"parameterRowType\" : 28, \"parameterColumnType\" : 424, \"_id\" : { \"$oid\" : \"654ebd9a56ed112462ccbbc2\" }, \"columns\" : [{ \"column\" : 1, \"rangeBegin\" : 0, \"rangeEnd\" : 999, \"_id\" : { \"$oid\" : \"654ebd9a56ed113796ccbbc3\" }, \"rows\" : [{ \"row\" : 1, \"rangeBegin\" : 0, \"rangeEnd\" : 89.99, \"value\" : 5.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed112b60ccbbcb\" } }, { \"row\" : 2, \"rangeBegin\" : 90, \"rangeEnd\" : 94.99, \"value\" : 6.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed111124ccbbca\" } }, { \"row\" : 3, \"rangeBegin\" : 95, \"rangeEnd\" : 99.99, \"value\" : 7.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed1171b1ccbbc9\" } }, { \"row\" : 4, \"rangeBegin\" : 100, \"rangeEnd\" : 104.99, \"value\" : 10.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed1126baccbbc8\" } }, { \"row\" : 5, \"rangeBegin\" : 105, \"rangeEnd\" : 109.99, \"value\" : 13.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed11ca0dccbbc7\" } }, { \"row\" : 6, \"rangeBegin\" : 110, \"rangeEnd\" : 114.99, \"value\" : 14.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed119908ccbbc6\" } }, { \"row\" : 7, \"rangeBegin\" : 115, \"rangeEnd\" : 119.99, \"value\" : 16, \"_id\" : { \"$oid\" : \"654ebd9a56ed111b95ccbbc5\" } }, { \"row\" : 8, \"rangeBegin\" : 120, \"rangeEnd\" : 999.99, \"value\" : 17.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed110663ccbbc4\" } }] }] }, { \"active\" : true, \"growthPlanCode\" : 2, \"planName\" : \"Plano Natura - Líder de Negócio\", \"leaderLevelCode\" : 9, \"leaderLevelName\" : \"Líder Ouro\", \"parameterRowType\" : 28, \"parameterColumnType\" : 424, \"_id\" : { \"$oid\" : \"654ebd9a56ed116596ccbbb8\" }, \"columns\" : [{ \"column\" : 1, \"rangeBegin\" : 0, \"rangeEnd\" : 999, \"_id\" : { \"$oid\" : \"654ebd9a56ed114c8fccbbb9\" }, \"rows\" : [{ \"row\" : 1, \"rangeBegin\" : 0, \"rangeEnd\" : 89.99, \"value\" : 6, \"_id\" : { \"$oid\" : \"654ebd9a56ed119feaccbbc1\" } }, { \"row\" : 2, \"rangeBegin\" : 90, \"rangeEnd\" : 94.99, \"value\" : 7, \"_id\" : { \"$oid\" : \"654ebd9a56ed11d321ccbbc0\" } }, { \"row\" : 3, \"rangeBegin\" : 95, \"rangeEnd\" : 99.99, \"value\" : 8, \"_id\" : { \"$oid\" : \"654ebd9a56ed111444ccbbbf\" } }, { \"row\" : 4, \"rangeBegin\" : 100, \"rangeEnd\" : 104.99, \"value\" : 11.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed1171f2ccbbbe\" } }, { \"row\" : 5, \"rangeBegin\" : 105, \"rangeEnd\" : 109.99, \"value\" : 14.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed11960bccbbbd\" } }, { \"row\" : 6, \"rangeBegin\" : 110, \"rangeEnd\" : 114.99, \"value\" : 15.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed11cd3fccbbbc\" } }, { \"row\" : 7, \"rangeBegin\" : 115, \"rangeEnd\" : 119.99, \"value\" : 17.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed117962ccbbbb\" } }, { \"row\" : 8, \"rangeBegin\" : 120, \"rangeEnd\" : 999.99, \"value\" : 19.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed111e53ccbbba\" } }] }] }, { \"active\" : true, \"growthPlanCode\" : 2, \"planName\" : \"Plano Natura - Líder de Negócio\", \"leaderLevelCode\" : 10, \"leaderLevelName\" : \"Líder Diamante\", \"parameterRowType\" : 28, \"parameterColumnType\" : 424, \"_id\" : { \"$oid\" : \"654ebd9a56ed111edbccbbae\" }, \"columns\" : [{ \"column\" : 1, \"rangeBegin\" : 0, \"rangeEnd\" : 999, \"_id\" : { \"$oid\" : \"654ebd9a56ed1137feccbbaf\" }, \"rows\" : [{ \"row\" : 1, \"rangeBegin\" : 0, \"rangeEnd\" : 89.99, \"value\" : 6.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed115da8ccbbb7\" } }, { \"row\" : 2, \"rangeBegin\" : 90, \"rangeEnd\" : 94.99, \"value\" : 7.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed11bba8ccbbb6\" } }, { \"row\" : 3, \"rangeBegin\" : 95, \"rangeEnd\" : 99.99, \"value\" : 8.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed112144ccbbb5\" } }, { \"row\" : 4, \"rangeBegin\" : 100, \"rangeEnd\" : 104.99, \"value\" : 13, \"_id\" : { \"$oid\" : \"654ebd9a56ed11f48eccbbb4\" } }, { \"row\" : 5, \"rangeBegin\" : 105, \"rangeEnd\" : 109.99, \"value\" : 16, \"_id\" : { \"$oid\" : \"654ebd9a56ed115d3accbbb3\" } }, { \"row\" : 6, \"rangeBegin\" : 110, \"rangeEnd\" : 114.99, \"value\" : 17, \"_id\" : { \"$oid\" : \"654ebd9a56ed115a4dccbbb2\" } }, { \"row\" : 7, \"rangeBegin\" : 115, \"rangeEnd\" : 119.99, \"value\" : 19.5, \"_id\" : { \"$oid\" : \"654ebd9a56ed113fabccbbb1\" } }, { \"row\" : 8, \"rangeBegin\" : 120, \"rangeEnd\" : 999.99, \"value\" : 22, \"_id\" : { \"$oid\" : \"654ebd9a56ed1110f7ccbbb0\" } }] }] }], \"updated\" : { \"$date\" : 1699659162297 }, \"__v\" : 0 }",
        "publish_date": "2024-03-27T18:53:58.652Z",
        "process_date": "2024-03-27T18:53:58.652Z",
        "group_leader_code": 158883969,
        "group_leader_name": "KELBIA DA SILVA MANZAN",
    }))
    json_credentials = json.loads(json.dumps(credential))
    credentials = Credentials(**json_credentials)
    tables = ["reward_summary_groups_v2",
              "payment_sap"]
    connection_config = ConnectionConfig(credentials, tables)
    connection = ORMInstance(connection_config=connection_config, consistency_level="LOCAL_QUORUM")

    for table in tables:
        result = connection.insert(json_data, table, True)
        result.add_callbacks(callback=lambda x: print(f"Inserted {json_data} into {table}"),
                             errback=lambda x: print(f"Failed to insert {json_data} into {table}"))
        sleep(1)
        select = connection.select(json_data, table)
        for row in select:
            print(row)
