# install_requires
<pre>
m-singleton==0.3 
pymongo==3.7.2
requests==2.25.1
unidecode==1.1.1
elasticsearch==7.17.4
</pre>
# Description
Version 0.2.x hỗ trợ việc tạo, chỉnh sửa, xóa dynamic field. Bạn có thể chủ động extend lại các BaseClass và thêm các giá trị.

* Kiến trúc chính của dynamic field  gồm 3 class chính

1) BaseHistory
2) BaseDataSelected
3) BaseField

# Examples

* BaseHistory

```python
from mobio.libs.dynamic_field.helpers.field_helper.base_field import BaseHistory
from datetime import datetime

field_history = BaseHistory()
field_history.set_staff_id("GiangNTH")
field_history.set_created_time(datetime.utcnow())
field_history.set_fullname("GiangNTH")
field_history.set_username("giangnth")
print(field_history.to_json())
```
Hoặc extend

```python
from mobio.libs.dynamic_field.helpers.field_helper.base_field import BaseHistory
from datetime import datetime
class ProfilingFieldHistory(BaseHistory):
    LAST_PREVIEW = "last_preview"

    def set_last_preview(self, last_preview: datetime):
        self.result[self.LAST_PREVIEW] = last_preview

    def get_last_preview(self):
        return self.result.get(self.LAST_PREVIEW)

field_history = ProfilingFieldHistory()
field_history.set_staff_id("GiangNTH")
field_history.set_created_time(datetime.utcnow())
field_history.set_fullname("GiangNTH")
field_history.set_username("giangnth")
field_history.set_last_preview(datetime.utcnow())
print(field_history.to_json())
```
* BaseDataSelected
```python
from mobio.libs.dynamic_field.helpers.field_helper.base_field import BaseDataSelected

data_1 = BaseDataSelected()
data_1.set_id(1)
data_1.set_color("c1")
data_1.set_enable(True)
data_1.set_value("value 1")
print(data_1.to_json())
```
Hoặc extend

```python
from mobio.libs.dynamic_field.helpers.field_helper.base_field import BaseDataSelected

class ProfilingDataSelectedTest(BaseDataSelected):
    IMAGE = "image"

    def set_image(self, image: str):
        if not image or (3 > len(image) or len(image) > 1000):
            raise Exception(
                "{}: must be between 3 and 1000 in length".format(self.IMAGE)
            )
        self.result[self.IMAGE] = image

    def get_image(self):
        return self.result.get(self.IMAGE)

data_1 = ProfilingDataSelectedTest()
data_1.set_id(1)
data_1.set_color("c1")
data_1.set_image("image1")
data_1.set_enable(True)
data_1.set_value("value 1")

data_2 = ProfilingDataSelectedTest()
data_2.set_all_data(id=2, image="image2", enable=False, value="value 2", color="c2")
```

* BaseField

BaseField class chứa các configs của field, vd như cấu hình màn hình hiển thị, định dạng dữ liệu, nhóm hiển thị của field... etc
Note: Field cũng có thể extend. :)
    
VD: 
>> add/update field
```python
from mobio.libs.dynamic_field.helpers.field_helper.base_field import BaseField, BaseDataSelected, BaseHistory
from flask import request
from mobio.libs.dynamic_field.helpers import (
    DynamicFieldStatus
)
from datetime import datetime
from mobio.libs.dynamic_field.controllers.i_base_dyn_controller import (
    IBaseDynController,
)


json_data = request.get_json() 

# SET FIELD PROPERTIES
dyn_field = BaseField()
dyn_field.set_field_name(json_data.get(BaseField.FIELD_NAME))
dyn_field.set_field_property(json_data.get(BaseField.FIELD_PROPERTY))
dyn_field.set_display_type(json_data.get(BaseField.DISPLAY_TYPE))
dyn_field.set_group(json_data.get(BaseField.GROUP))
dyn_field.set_is_base(False)
dyn_field.set_status(DynamicFieldStatus.ENABLE)
dyn_field.set_support_sort(True)
dyn_field.set_enable_data_color(json_data.get(BaseField.ENABLE_DATA_COLOR))

data_1 = BaseDataSelected()
data_1.set_id(1)
data_1.set_color("c1")
data_1.set_enable(True)
data_1.set_value("value 1")
dyn_field.set_data_selected([data_1])

# SET FIELD HISTORY
field_history = BaseHistory()
field_history.set_staff_id("GiangNTH")
field_history.set_created_time(datetime.utcnow())
field_history.set_fullname("GiangNTH")
field_history.set_username("giangnth")
# SAVE TO DB and push ELS mapping. This function can detect add/update field 
IBaseDynController(
            mongo_url_connection="mongodb://test_user:test_pass@0.0.0.0:27017/test_db"
        ).save_field(
            merchant_id="uuid",
            field_class=dyn_field,
            updated_by=field_history,
            els_index="mobio-profiling",
            els_doc_type="p_raw",
        )
```

>> Remove field
```python
from mobio.libs.dynamic_field.helpers.field_helper.base_field import BaseHistory
from datetime import datetime
from mobio.libs.dynamic_field.controllers.i_base_dyn_controller import (
    IBaseDynController,
)

field_key = "_dyn_giang_test_v2_p2_1645462060103"
field_history = BaseHistory()
field_history.set_staff_id("GiangNTH")
field_history.set_created_time(datetime.utcnow())
field_history.set_fullname("GiangNTH")
field_history.set_username("giangnth")

result = IBaseDynController(
    mongo_url_connection="mongodb://test_user:test_pass@0.0.0.0:27017/test_db"
).remove_field(
    merchant_id="uuid",
    field_key=field_key,
    updated_by=field_history,
)
print("result remove field: {}: {}".format(field_key, result))
```

# Example config
```
[Elastic]
index = dyn_test
doc_type = df
```


# Change logs
* 0.2.5
    1) remove doc_type
* 0.2.4
    1) upgrade elasticsearch_client to 7.17.4
* 0.2.3
    1) remove flask, flask-cors in install_requires
* 0.2.2
    1) Everything can be extend
    2) Logging field change model
* 0.1.3
    1) remove some print
    2) fix create mapping integer to long
* 0.1.2
    1) fix missing model elastic
*  0.1.1
    1) add singleton to ElasticSearchBaseModel

*  0.1.0
    1) use elastic base model
    2) change function args <b>add_els_config</b>
    <pre>
    def add_els_config(self, index, doc_type):
        self.index = index
        self.doc_type = doc_type
    </pre>
