import setuptools

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setuptools.setup(
    name="chalice-http-toolkit",
    author="Chris Lapa",
    author_email="",
    description="Several helpers for building serverless websites using Chalice",
    long_description=long_description,
    long_description_content_type="text/markdown",
    use_scm_version=True,
    setup_requires=['setuptools_scm'],
    url="https://gitlab.com/chalice-http-toolkit/chalice-http-toolkit",
    project_urls={
        "Bug Tracker": "https://gitlab.com/chalice-http-toolkit/chalice-http-toolkit/-/issues",
    },
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    packages=setuptools.find_packages(),
    python_requires=">=3.8",
    install_requires=['chalice>=1.22.3',
                      'python-magic==0.4.22',
                      'requests-toolbelt==0.9.1'],
    extras_require={
        'layered': ['Jinja2==2.10',
                    'Pillow==8.2.0']
        }
    )