"""
TODO: This module has to be removed as the new
VideoEditor has been created. Or, at least, you
need to refactor it completely. But please,
check the way we were handling the values before
to allow splitting a video but maintaining the
previous changes.
"""
"""
TODO: Check the real limits of 'color_temperature',
'color_hue' and all those properties I would let to
be changed, so I can use the proper limits within 
the setter method.

TODO: Please, see the 'SubClip' class in the 
'yta_multimedia' library as it was ready to handle
attributes with values for each frame.

The VideoWrapped has properties/attributes whose
values are generated by a special class we call
modifier. That modifier is able to calculate the
values according to the number of frames and its
settings. We use these modifiers because videos
are dynamic, so those values can change when we
extend the video duration (so the number of 
frames changes) or apply other changes. Once an
attribute is set, the modifier passed as 
parameter calculates the values and set them as
the attribute values until a new modification
is done. If the attribute is modified again, the
values will be recalculated. If the video suffer
other changes (change duration, apply effect, 
etc.), those values will remain intact but can
be duplicated or removed to fit the new changes.

If we have a video of 5 fps and we set the 
brightness to from 0 to 100, it will be:
- frame 0: brightness = 0
- frame 1: brightness = 25
- frame 2: brightness = 50
- frame 3: brightness = 75
- frame 4: brightness = 100

So, if we decide to split the video between the
1st and 2nd frame, we need to obtain 2 videos, 
vA and vB, that will be:
- vA. frame 0: brightness = 0
- vA. frame 1: brightness = 25
- vB. frame 2: brightness = 50
- vB. frame 3: brightness = 75
- vB. frame 4: brightness = 100

As you can see, when we set the brightness the
first time, the values were calculated and set,
but when we split the video we want those 
values to be preserved, and thats why we need
to calculate values only when setting them for
the first time. If we want to recalculate the
values for each new video, we just need to set
the modifier again for each of those videos,
and the new values will be calculated according
to the new number of frames they have.
"""
from yta_video_editor.settings import COLOR_TEMPERATURE_LIMIT, COLOR_HUE_CHANGE_LIMIT, BRIGHTNESS_LIMIT, CONTRAST_LIMIT, SHARPNESS_LIMIT, WHITE_BALANCE_LIMIT
from yta_video_utils.duration import EnshortVideoMode, ExtendVideoMode, set_video_duration
from yta_video_moviepy.t import T
# TODO: This was different before, I am changing
# everything so this will not work...
from yta_video_base.video import Video as BaseVideoWrapped
from yta_image_base.editor import ImageEditor
from yta_validation import PythonValidator
from yta_validation.parameter import ParameterValidator
from moviepy.Clip import Clip
from typing import Union


class VideoWrapped:
    """
    Class to wrap a video and implement basic
    edition functionalities. The video can be
    a part of a moviepy video that has been
    splitted to modify only one part of it.
    """

    @property
    def video(
        self
    ) -> BaseVideoWrapped:
        """
        The BaseVideoWrapped instance.
        """
        return self._video
    
    @property
    def number_of_frames(
        self
    ) -> int:
        """
        The number of video frames that exist
        in the video.
        """
        return self.video.number_of_frames
    
    @property
    def fps(
        self
    ) -> float:
        """
        Frames per second of the original video.
        """
        return self.video.fps
    # TODO: Add more properties that exist in the
    # BaseVideoWrapped like this 'number_of_frames'

    @property
    def final_video(
        self
    ):
        """
        Get a copy of the original clip but modified
        according to the changes that must be done
        by considering this instance properties.
        """
        moviepy_video = self.video.video

        # 1st. Modify the frame image
        def modify_video_frame_by_frame(
            get_frame,
            t
        ):
            """
            Modificate anything related to frame image: pixel
            colors, distortion, etc.
            """
            frame = get_frame(t)
            frame_index = T.frame_time_to_frame_index(t, moviepy_video.fps)

            # TODO: This is not ok. If we split a video we
            # need to preserve the attributes values that
            # have been previously calculated for each
            # frame.
            # Color temperature
            frame = (
                ImageEditor.modify_color_temperature(frame, self.color_temperature[frame_index])
                if self.color_temperature is not None else
                frame
            )

            # Color hue
            frame = (
                ImageEditor.modify_color_hue(frame, self.color_hue[frame_index])
                if self.color_hue is not None else
                frame
            )

            # Brightness
            frame = (
                ImageEditor.modify_brightness(frame, self.brightness[frame_index])
                if self.brightness is not None else
                frame
            )

            # Contrast
            frame = (
                ImageEditor.modify_contrast(frame, self.contrast[frame_index])
                if self.contrast is not None else
                frame
            )

            # Sharpness
            frame = (
                ImageEditor.modify_sharpness(frame, self.sharpness[frame_index])
                if self.sharpness is not None else
                frame
            )

            # White balance
            frame = (
                ImageEditor.modify_white_balance(frame, self.white_balance[frame_index])
                if self.white_balance is not None else
                frame
            )

            return frame
        
        # Apply video (image) modifications frame by frame
        moviepy_video = moviepy_video.transform(lambda get_frame, t: modify_video_frame_by_frame(get_frame, t))

        # TODO: Edit audio and more
        # 2nd. Modify the frame audio
        def modify_audio_frame_by_frame(
            get_frame,
            t
        ):
            # The 't' time moment is here a numpy array
            # of a lot of consecutive time moments (maybe
            # 1960). That ishow it works internally
            frame = get_frame(t)
            frame_index = T.get_frame_index_from_audio_frame_time(t[len(t) // 2], moviepy_video.fps)

            # TODO: This must be an optional dependency then (?)
            from yta_audio_base.audio import Audio

            # Volume
            # TODO: Volume must be avalue between 0 and 500
            frame = (
                Audio(frame).with_volume(self.volume[frame_index])
                if self.volume is not None else
                frame
            )

            return frame

        # Apply video (audio) modifications frame by frame
        if moviepy_video.audio is not None:
            audio = moviepy_video.audio.copy()
            audio = audio.transform(lambda get_frame, t: modify_audio_frame_by_frame(get_frame, t))
            moviepy_video = moviepy_video.with_audio(audio)

        # TODO: See 'SubClip' class in 'yta_multimedia' project

        return moviepy_video
    
    @property
    def copy(
        self
    ) -> 'VideoWrapped':
        copy = VideoWrapped(self.video.video.copy())

        # The only thing we need to preserve is the values that
        # modify each attribute. The modifier instance is only
        # passed to generate these values, so that generator is
        # only necessary once to generate those values
        copy._color_temperature = (
            self._color_temperature.copy()
            if self._color_temperature is not None else
            None
        )
        copy._color_hue = (
            self._color_hue.copy()
            if self._color_hue is not None else
            None
        )
        copy._brightness = (
            self._brightness.copy()
            if self._brightness is not None else
            None
        )
        copy._contrast = (
            self._contrast.copy()
            if self._contrast is not None else
            None
        )
        copy._sharpness = (
            self._sharpness.copy()
            if self._sharpness is not None else
            None
        )

        return copy

    def __init__(
        self,
        video: 'Clip'
    ):
        """
        These properties, set as None, mean no 
        modification, and having a value means that
        must modify the video. See the properties
        description to know more about the limits.
        """
        self._color_temperature = None
        """
        The set of values, for each frame, of the
        color temperature attribute.
        """
        self._color_hue = None
        """
        The set of values, for each frame, of the
        color hue attribute.
        """
        self._brightness = None
        """
        The set of values, for each frame, of the
        brightness attribute.
        """
        self._contrast = None
        """
        The set of values, for each frame, of the
        contrast attribute.
        """
        self._sharpness = None
        """
        The set of values, for each frame, of the
        sharpness attribute.
        """
        
        self._video = BaseVideoWrapped(video)

    def change_duration(
        self,
        duration: float,
        extend_mode: ExtendVideoMode = ExtendVideoMode.default(),
        enshort_mode: EnshortVideoMode = EnshortVideoMode.default()
    ):
        """
        Get this video with the provided 'duration' applying
        the strategy that the 'extend_mode' or 'enshort_mode'
        parameters determine according to the original video
        duration.
        """
        ParameterValidator.validate_mandatory_positive_number('duration', duration, do_include_zero = False)
        extend_mode = ExtendVideoMode.to_enum(extend_mode)
        enshort_mode = EnshortVideoMode.to_enum(enshort_mode)

        return set_video_duration(self.video.video, duration, extend_mode, enshort_mode)
    
    # TODO: I think we don't need this method below here
    # and less in the VideoEditor...
    # def as_mask(
    #     self,
    #     masking_method: MoviepyFrameMaskingMethod = MoviepyFrameMaskingMethod.MEAN
    # ) -> Clip:
    #     """
    #     Get a new video that is a mask by applying the
    #     masking strategy passed as 'masking_method'
    #     parameter. This will modify each pixel to 
    #     transform it into a opacity value between 0.0
    #     and 1.0.
    #     """
    #     from yta_video_moviepy.generator import MoviepyMaskClipGenerator

    #     MoviepyMaskClipGenerator.video_to_mask(self.video.video)
    #     # masking_method = MoviepyFrameMaskingMethod.to_enum(masking_method)

    #     # # TODO: This is ok but very slow I think...
    #     # mask_clip_frames = [
    #     #     VideoFrame(frame).as_mask(masking_method)
    #     #     for frame in self.video.video.iter_frames()
    #     # ]

    #     # return VideoClip(lambda t: mask_clip_frames[int(t * self.fps)], is_mask = True).with_fps(self.fps)

# TODO: Maybe move this code below to a validation file (?)
def _validate_is_video_attribute_modifier_instance(
    element: VideoWrappedAttributeModifier
):
    if not PythonValidator.is_instance(element, VideoWrappedAttributeModifier):
        raise Exception('The provided parameter is not a SubClipAttributeModifier instance.')
    
def _validate_attribute_modifier(
    attribute_modifier: VideoWrappedAttributeModifier,
    name: str,
    limit_range: tuple[float, float],
    number_of_frames: int
):
    """
    Validate the provided 'attribute_modifier' according to
    the given 'limit_range' in which all the values must fit.
    """
    ParameterValidator.validate_mandatory_instance_of(name, attribute_modifier, VideoWrappedAttributeModifier)
    
    # TODO: Careful, some of the easing functions we use
    # have values out of the limits, so this would limit
    # the number o easing functions we can use...
    attribute_modifier.validate_values(number_of_frames, limit_range)