# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['p3do']

package_data = \
{'': ['*']}

install_requires = \
['Fabric>=2.7.0,<3.0.0',
 'click>=8.1,<9.0',
 'cryptography>=37.0.3,<38.0.0',
 'python-keycloak>=0.27,<0.28',
 'requests>=2.27.1,<3.0.0',
 'urllib3>=1.26.9,<2.0.0']

entry_points = \
{'console_scripts': ['p3do = p3do.cli:cli']}

setup_kwargs = {
    'name': 'p3do',
    'version': '0.2.0',
    'description': 'CLI utilities for p3d',
    'long_description': '<div align="center">\n\n# p3do - let \'em minions do it\n\n![PyPI - License](https://img.shields.io/pypi/l/p3do)\n![PyPI](https://img.shields.io/pypi/v/p3do)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/p3do)\n\np3do (pronounced _pee-three-duh_) is a collection of command-line utilities for\np3d. It allows you to conjure some tedious operations right from your magic little\nfingertips.\n\n<img src="res/p3do-animation.gif?raw=true" alt="p3do in action" width="75%"/>\n\n<p />\n\n[Installation](#installation) •\n[Getting started](#getting-started) •\n[Commands](#commands) •\n[Contribute](#contribute)\n\n</div>\n\n## Installation\n\n`p3do` is built on Python 3.8 or later installed. You can get Python from your\npackage manager du jour or download and install it from\nhttps://www.python.org/downloads/ (looking at you Windows. Mac.\nWhyihavetobother. Veryannoyingyouare.)\n\n`p3do` is published to the [CheeseShop](https://pypi.org/project/p3do/) and\nhence can be installed with pip:\n\n```bash\npip install p3do\n```\n\n`p3do` installs itself as a command. If your `$PATH` is set up correctly you\nwill be able to just invoke `p3do` like so\n\n```bash\np3do --help\n```\n\n## Getting Started\n\nLight a bonfire and whisper _p3do_ in the most conspirative voice available to\nyou. Then start a terminal.\n\n`p3do` is hierarchical, self-documenting and discoverable. The best way to start\nis to just type `p3do`. This will show you the available commands and some\ndescription. From there you can drill down the hierarchy for useful sub-command.\n\nEach sub-command/command group has special flags and configuration. How to use\nthem is explained in [Commands](#commands) for each of them separately. You can\nalso use `p3d <group> <command> --help` in your terminal for concise on-line\nhelp.\n\n## Commands\n\n`p3do` is hierarchical. Commands are batched into groups which can be further\nnested into parent groups. We follow the same principle in the documentation\nhere.\n\n* [`pp`](#pp): PoolParty commands\n    - [`encrypt`](#encrypt): Encrypt a clear text with poolparty encryption\n    - [`decrypt`](#decrypt): Decrypt a secret text with poolparty encryption\n\n* [`kc`](#kc): Keycloak commands\n    - [KC Configuration](#kc-configuration): Not a command but read this first!\n    - [`add-mappers`](#add-mappers): Add mappers to IdPs from realm export\n\n### pp\n\nCommands in this group allow to perform operations useful for or related to\nour dear PoolParty.\n\n### encrypt\n\nEncrypt a clear text with PoolParty encryption. The parameters for encryption\nused by PoolParty can usually be found in the `poolparty.properties` file.\n\nTo make sure that your command line processor does not mingle the input, always\nwrap the clear text, password, and salt it in quotes.\n\n``` bash\n# encrypt "mysecret" with \n# password "H7dwBFDh3gEVDH1YecgikmOBpx9kKZ9nj1wJ5ZuhEeg="\n# salt Y+Fw/4dHBajqEGxOsEyfNSGsYYXE7JUyLmc3nRFrB84=\n# and 256 rounds\np3do pp encrypt "mysecret" "H7dwBFDh3gEVDH1YecgikmOBpx9kKZ9nj1wJ5ZuhEeg=" "Y+Fw/4dHBajqEGxOsEyfNSGsYYXE7JUyLmc3nRFrB84=" 256\n```\n\n### decrypt\nDecrypt a secret text encrypted by PoolParty. The parameters for encryption/decryption used\nby PoolParty can usually be found in the `poolparty.properties` file.\n\nTo make sure that your command line processor does not mingle the input, always\nwrap the secret, password, and salt it in quotes.\n\n``` bash\n# decrypt 6NjzLmQp7kGM7bbezhQX1G2hrqCoqLrC32ayBTjQVjU= with \n# password H7dwBFDh3gEVDH1YecgikmOBpx9kKZ9nj1wJ5ZuhEeg=\n# salt Y+Fw/4dHBajqEGxOsEyfNSGsYYXE7JUyLmc3nRFrB84=\n# and 256 rounds\np3do pp decrypt "6NjzLmQp7kGM7bbezhQX1G2hrqCoqLrC32ayBTjQVjU=" "H7dwBFDh3gEVDH1YecgikmOBpx9kKZ9nj1wJ5ZuhEeg=" "Y+Fw/4dHBajqEGxOsEyfNSGsYYXE7JUyLmc3nRFrB84=" 256\n```\n\n\n### kc\n\nCommands in this group allow to perform operations for Keycloak. Most of them\nneed authentication and server information. Please read [KC\nConfiguration](#kc-configuration) first on how to add your configuration.\n\nCommands:\n* [KC Configuration](#kc-configuration): Not a command but read this first!\n* [`add-mappers`](#add-mappers): Add mappers to IdPs from realm export\n\n#### KC Configuration\n\nkc commands usually need some information about the server, realm and\nauthentication. This information can be read from a configuration file, given\nvia CLI parameters or interactively if information is missing. CLI parameters\ntake precendence and override any configuration read from a configuration file.\n\n***Note:*** you don\'t need a configuration file at all. All (partial) parameters\ncan be specified via CLI arguments. Just leave out the `--auth_config` and\n`--auth` flags.\n\nA full configuration file which specifies all available options looks like this:\n\n```ini\n[test]\nserver=https://keycloak.example.com/auth/\nusername=admin\nuser_realm_name=master\npassword=password\nrealm_name=my-app\n```\n\n`[test]` is the name of the configuration. You can have multiple configurations\nfor different servers in your config file. `server`, `username`, `password` are\nrather self-explanatory. `user_realm_name` is the realm the _user_ is in. This\nis not necessarily the same realm as the one you want to modify. `realm_name` is\nthe realm name you want to modify (it usually does not make sense to put this\ninto the config file).\n\nTo specify the config file and config name you want to use, invoke a `p3do` command like this:\n\n```bash\n# `config.ini` is the config file, `test` is the config section you want to use\np3do kc add-mappers --auth_config config.ini --auth test <...other arguments...>\n```\n\nNote that you can override any configuration via CLI arguments:\n\n```bash\n# Override `admin` from `config.ini` with `admin2`\np3do kc add-mappers --auth_config config.ini --auth test --username admin2 <...other arguments...>\n```\n\nThe configuration can also be partial:\n```ini\n[partial-test]\nserver=https://keycloak.example.com/auth/\nusername=admin\nuser_realm_name=master\n```\n\nNote that we don\'t specify a `password` or `realm_name` here. You can now invoke `p3do` with\n\n```bash\n# Complete `partial-test` via arguments\np3do kc add-mappers --auth_config config.ini --auth partial-test --password password --realm_name my-other-app <...other arguments...>\n```\n\nYou can also just invoke `p3do` as before and will be asked interactively to fill out the missing pieces:\n\n```bash\n# No `password` or `realm_name` from `config.ini` or cli arguments\np3do kc add-mappers --auth_config config.ini --auth partial-test <...other arguments...>\n# `p3do` will ask you to complete them interactively\nPassword: password\nRealm_name: my-other-app\n```\n\n#### add-mappers\n\nAdd IdP mappers from a realm export `.json` to a realm. The IdP must already\nexist and correspond to the IdP name specified in the mapper config. Keycloak\ndoes not import mapper configuration by itself (yet?).\n\n```bash\n# `realm-export.json` is the path the the export file\np3do kc add-mappers --auth_config config.ini --auth test realm-export.json\n```\n\n## Contribute\n\n***`p3do` is licensed under MIT and published to PyPI (including source). Do not\nadd sensitive company data. Any sensitive data has to be read from external\nconfiguration files.***\n\n### Contributors\n\nAll contributions are welcome. This can be new commands, improvements to the\non-line help, documentation or spelling mistakes. Just open a PR with your\nchanges. If your changes are larger, you find a bug but don\'t know how to fix\nit, or you are just unsure if your idea fits, open an issue on GitHub first.\n\n### Maintainers\n\nThe `p3do` main branch is protected and PRs have to be approved by by\n[maintainers](CODEOWNERS) (code owners in GitHub lingo). Tooling like this can\neasily grow out of control. Maintainers ensure that this is not happening to\n`p3do`. Here are some guidelines.\n\n- Every command in `p3do` must have a well known and feasible (manual)\n  alternative\n- `p3do` must not smear over too complicated process. If a process is too\n  complicated fix the process.\n- `p3do` must not obfuscate processes. If knowledge about how things work isn\'t\n  spread enough, spread it.\n- `p3do` must not gatekeep processes. It is not a mechanism for access\n  management.\n- `p3do` believes in the competency of its users\n\n### Release Maintainers\n\nReleases are pushed to [PyPI](https://pypi.org/project/p3do/). This requires\na token with Maintainer or Owner status on PyPI.\n\nReleases are automatically created and pushed by a [GitHub\nAction](https://github.com/swc-friedla/p3do/actions/workflows/publish.yml) when\na tagged release is created in GitHub.\n\nRepository and release maintainers is probably but not necessarily the same set\nof people.\n',
    'author': 'Armin Friedl',
    'author_email': 'armin.friedl@semantic-web.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
