# Generated by Django 4.2.16 on 2024-11-26 01:48

import ansible_base.resource_registry.models.service_identifier
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('dab_resource_registry', '0006_alter_resource_service_id'),
    ]

    operations = [
        migrations.AlterField(
            model_name='resource',
            name='ansible_id',
            field=models.UUIDField(db_index=True, default=uuid.uuid4, help_text='A unique ID identifying this resource by the resource server.', unique=True),
        ),
        migrations.AlterField(
            model_name='resource',
            name='content_type',
            field=models.ForeignKey(help_text='The content type for this resource.', on_delete=django.db.models.deletion.CASCADE, related_name='resources', to='contenttypes.contenttype'),
        ),
        migrations.AlterField(
            model_name='resource',
            name='is_partially_migrated',
            field=models.BooleanField(default=False, help_text="A flag indicating that the resource has been copied into the resource server, but the service_id hasn't been updated yet."),
        ),
        migrations.AlterField(
            model_name='resource',
            name='name',
            field=models.CharField(help_text='The name of this resource.', max_length=512, null=True),
        ),
        migrations.AlterField(
            model_name='resource',
            name='object_id',
            field=models.TextField(db_index=True, help_text='The object id for this resource.'),
        ),
        migrations.AlterField(
            model_name='resource',
            name='service_id',
            field=models.UUIDField(default=ansible_base.resource_registry.models.service_identifier.service_id, help_text='ID of the service responsible for managing this resource.'),
        ),
        migrations.AlterField(
            model_name='resourcetype',
            name='content_type',
            field=models.OneToOneField(help_text='The content type for this resource type.', on_delete=django.db.models.deletion.CASCADE, related_name='resource_type', to='contenttypes.contenttype'),
        ),
        migrations.AlterField(
            model_name='resourcetype',
            name='externally_managed',
            field=models.BooleanField(help_text='Is this resource type managed externally from this service.'),
        ),
        migrations.AlterField(
            model_name='resourcetype',
            name='name',
            field=models.CharField(db_index=True, editable=False, help_text='The name of this resource type.', max_length=256, unique=True),
        ),
    ]
