# Generated by Django 4.2.6 on 2024-03-01 18:41

from django.db import migrations, models

import ansible_base.resource_registry.models.resource


def reset_service_id(apps, schema_editor):
    ServiceID = apps.get_model("dab_resource_registry", "ServiceID")
    Resource = apps.get_model("dab_resource_registry", "Resource")
    Resource.objects.all().update(service_id=ServiceID.objects.first().id)


def revert_post_migrate(apps, schema_editor):
    "Resources are created post-migrate, and prior model is incompatible anyway, so delete them"
    Resource = apps.get_model("dab_resource_registry", "Resource")
    Resource.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('dab_resource_registry', '0001_initial'),
    ]

    operations = [
        migrations.RenameField(
            model_name='resource',
            old_name='resource_id',
            new_name='ansible_id',
        ),
        migrations.AlterField(
            model_name='resource',
            name='service_id',
            field=models.CharField(max_length=38),
        ),
        migrations.RunPython(
            code=reset_service_id,
            reverse_code=revert_post_migrate
        ),
        migrations.AlterField(
            model_name='resource',
            name='service_id',
            field=models.UUIDField(default=ansible_base.resource_registry.models.resource.service_id),
        ),
    ]
