# Generated by Django 4.2.16 on 2024-11-26 20:41

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('dab_rbac', '0002_alter_objectrole_provides_teams_and_more'),
    ]

    operations = [
        migrations.AlterField(
            model_name='dabpermission',
            name='codename',
            field=models.CharField(help_text='A codename for the permission, in the format {action}_{model_name}. Where action is typically the view set action (view/list/etc) from Django rest framework.', max_length=100, verbose_name='codename'),
        ),
        migrations.AlterField(
            model_name='dabpermission',
            name='content_type',
            field=models.ForeignKey(help_text='The content type this permission will apply to.', on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype', verbose_name='content type'),
        ),
        migrations.AlterField(
            model_name='dabpermission',
            name='name',
            field=models.CharField(help_text='The name of this permission.', max_length=255, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='objectrole',
            name='content_type',
            field=models.ForeignKey(help_text='The content type of the subject of permission assignments. Duplicated from related RoleDefinition.', on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype'),
        ),
        migrations.AlterField(
            model_name='objectrole',
            name='object_id',
            field=models.TextField(help_text='The database primary key of the subject of permission assignments.'),
        ),
        migrations.AlterField(
            model_name='roledefinition',
            name='description',
            field=models.TextField(blank=True, help_text='A description of this role.'),
        ),
        migrations.AlterField(
            model_name='roledefinition',
            name='managed',
            field=models.BooleanField(default=False, editable=False, help_text='Is this role managed by the system (not changeable by the users).'),
        ),
        migrations.AlterField(
            model_name='roledefinition',
            name='name',
            field=models.TextField(db_index=True, help_text='The name of this role.', unique=True),
        ),
        migrations.AlterField(
            model_name='roleevaluation',
            name='content_type_id',
            field=models.PositiveIntegerField(help_text='The related content type id.'),
        ),
        migrations.AlterField(
            model_name='roleevaluation',
            name='object_id',
            field=models.PositiveIntegerField(help_text='The id of the object that the related role gives the related permission to.'),
        ),
        migrations.AlterField(
            model_name='roleevaluationuuid',
            name='content_type_id',
            field=models.PositiveIntegerField(help_text='The related content type id.'),
        ),
        migrations.AlterField(
            model_name='roleevaluationuuid',
            name='object_id',
            field=models.UUIDField(help_text='The object UUID this role evaluation will be applied to.'),
        ),
        migrations.AlterField(
            model_name='roleteamassignment',
            name='content_type',
            field=models.ForeignKey(help_text='The content type this applies to.', null=True, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype'),
        ),
        migrations.AlterField(
            model_name='roleteamassignment',
            name='object_role',
            field=models.ForeignKey(editable=False, help_text='A roll-up of the fields (role_definition, content_type).', null=True, on_delete=django.db.models.deletion.CASCADE, to='dab_rbac.objectrole'),
        ),
        migrations.AlterField(
            model_name='roleteamassignment',
            name='team',
            field=models.ForeignKey(help_text='The team that receives permissions.', on_delete=django.db.models.deletion.CASCADE, related_name='role_assignments', to=settings.ANSIBLE_BASE_TEAM_MODEL),
        ),
        migrations.AlterField(
            model_name='roleuserassignment',
            name='content_type',
            field=models.ForeignKey(help_text='The content type this applies to.', null=True, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype'),
        ),
        migrations.AlterField(
            model_name='roleuserassignment',
            name='object_role',
            field=models.ForeignKey(editable=False, help_text='A roll-up of the fields (role_definition, content_type).', null=True, on_delete=django.db.models.deletion.CASCADE, to='dab_rbac.objectrole'),
        ),
        migrations.AlterField(
            model_name='roleuserassignment',
            name='user',
            field=models.ForeignKey(help_text='The user this role is assigned to.', on_delete=django.db.models.deletion.CASCADE, related_name='role_assignments', to=settings.AUTH_USER_MODEL),
        ),
    ]
