# Generated by Django 4.2.16 on 2024-11-21 11:14

import ansible_base.authentication.models.authenticator
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('dab_authentication', '0014_authenticator_auto_migrate_users_to'),
    ]

    operations = [
        migrations.AlterField(
            model_name='authenticator',
            name='category',
            field=models.CharField(default=None, help_text='The base type of this authenticator.', max_length=30),
        ),
        migrations.AlterField(
            model_name='authenticator',
            name='configuration',
            field=models.JSONField(blank=True, default=dict, help_text='The required configuration for this source.'),
        ),
        migrations.AlterField(
            model_name='authenticator',
            name='create_objects',
            field=models.BooleanField(default=True, help_text='Allow authenticator to create objects (users, teams, organizations).'),
        ),
        migrations.AlterField(
            model_name='authenticator',
            name='created',
            field=models.DateTimeField(auto_now_add=True, help_text='The date/time this resource was created.'),
        ),
        migrations.AlterField(
            model_name='authenticator',
            name='created_by',
            field=models.ForeignKey(default=None, editable=False, help_text='The user who created this resource.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='%(app_label)s_%(class)s_created+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='authenticator',
            name='enabled',
            field=models.BooleanField(default=False, help_text='Should this authenticator be enabled.'),
        ),
        migrations.AlterField(
            model_name='authenticator',
            name='modified',
            field=models.DateTimeField(auto_now=True, help_text='The date/time this resource was created.'),
        ),
        migrations.AlterField(
            model_name='authenticator',
            name='modified_by',
            field=models.ForeignKey(default=None, editable=False, help_text='The user who last modified this resource.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='%(app_label)s_%(class)s_modified+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='authenticator',
            name='name',
            field=models.CharField(help_text='The name of this resource.', max_length=512, unique=True),
        ),
        migrations.AlterField(
            model_name='authenticator',
            name='order',
            field=models.IntegerField(default=ansible_base.authentication.models.authenticator.get_next_authenticator_order, help_text='The order in which an authenticator will be tried. This only pertains to username/password authenticators.'),
        ),
        migrations.AlterField(
            model_name='authenticator',
            name='remove_users',
            field=models.BooleanField(default=True, help_text='When a user authenticates from this source should they be removed from any other groups they were previously added to.'),
        ),
        migrations.AlterField(
            model_name='authenticator',
            name='slug',
            field=models.SlugField(default=None, editable=False, help_text='An immutable identifier for the authenticator.', max_length=1024, unique=True),
        ),
        migrations.AlterField(
            model_name='authenticator',
            name='type',
            field=models.CharField(editable=False, help_text='The type of authentication service this is.', max_length=256),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='authenticator',
            field=models.ForeignKey(help_text='The authenticator this mapping belongs to.', on_delete=django.db.models.deletion.CASCADE, related_name='authenticator_maps', to='dab_authentication.authenticator'),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='created',
            field=models.DateTimeField(auto_now_add=True, help_text='The date/time this resource was created.'),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='created_by',
            field=models.ForeignKey(default=None, editable=False, help_text='The user who created this resource.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='%(app_label)s_%(class)s_created+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='map_type',
            field=models.CharField(choices=[('allow', 'allow'), ('is_superuser', 'is_superuser'), ('role', 'role'), ('organization', 'organization'), ('team', 'team')], default='team', help_text='What will the map grant the user? System access (allow) a team or organization membership, the superuser flag or a role in the system.', max_length=17),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='modified',
            field=models.DateTimeField(auto_now=True, help_text='The date/time this resource was created.'),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='modified_by',
            field=models.ForeignKey(default=None, editable=False, help_text='The user who last modified this resource.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='%(app_label)s_%(class)s_modified+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='name',
            field=models.CharField(help_text='The name of this resource.', max_length=512),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='order',
            field=models.PositiveIntegerField(default=0, help_text='The order in which this rule should be processed, smaller numbers are of higher precedence. Items with the same order will be executed in random order.'),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='organization',
            field=models.CharField(blank=True, default=None, help_text='An organization name this rule works on.', max_length=512, null=True),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='revoke',
            field=models.BooleanField(default=False, help_text='Should we revoke the permission if a user does not meet this rule.'),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='role',
            field=models.CharField(blank=True, default=None, help_text='The role this map will grant the authenticating user to the targeted object.', max_length=512, null=True),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='team',
            field=models.CharField(blank=True, default=None, help_text='A team name this rule works on.', max_length=512, null=True),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='triggers',
            field=models.JSONField(blank=True, default=dict, help_text='Trigger information for this rule.'),
        ),
        migrations.AlterField(
            model_name='authenticatormap',
            name='revoke',
            field=models.BooleanField(default=False, help_text='Revoke the permission if a user does not meet this rule.'),
        ),
        migrations.AddField(
            model_name='authenticatormap',
            name='enabled',
            field=models.BooleanField(default=True, help_text='Enables or disables this authenticator map'),
        ),
    ]
