# Generated by Django 4.2.6 on 2024-01-18 20:16

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import social_django.storage


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Authenticator',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(default=None, editable=False, help_text='The date/time this resource was created')),
                ('modified_on', models.DateTimeField(default=None, editable=False, help_text='The date/time this resource was created')),
                ('name', models.CharField(help_text='The name of this resource', max_length=512, unique=True)),
                ('enabled', models.BooleanField(default=False, help_text='Should this authenticator be enabled')),
                ('create_objects', models.BooleanField(default=True, help_text='Allow authenticator to create objects (users, teams, organizations)')),
                ('users_unique', models.BooleanField(default=False, help_text='Are users from this source the same as users from another source with the same id')),
                ('remove_users', models.BooleanField(default=True, help_text='When a user authenticates from this source should they be removed from any other groups they were previously added to')),
                ('configuration', models.JSONField(blank=True, default=dict, help_text='The required configuration for this source')),
                ('type', models.CharField(editable=False, help_text='The type of authentication service this is', max_length=256)),
                ('order', models.IntegerField(default=1, help_text='The order in which an authenticator will be tried. This only pertains to username/password authenticators')),
                ('slug', models.SlugField(default=None, editable=False, help_text='An immutable identifier for the authenticator', max_length=1024, unique=True)),
                ('category', models.CharField(default=None, help_text='The base type of this authenticator', max_length=30)),
                ('created_by', models.ForeignKey(default=None, editable=False, help_text='The user who created this resource', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='%(app_label)s_%(class)s_created+', to=settings.AUTH_USER_MODEL)),
                ('modified_by', models.ForeignKey(default=None, editable=False, help_text='The user who last modified this resource', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='%(app_label)s_%(class)s_modified+', to=settings.AUTH_USER_MODEL)),
                ('users', models.ManyToManyField(blank=True, help_text='The list of users who have authenticated from this authenticator', related_name='users', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AuthenticatorMap',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_on', models.DateTimeField(default=None, editable=False, help_text='The date/time this resource was created')),
                ('modified_on', models.DateTimeField(default=None, editable=False, help_text='The date/time this resource was created')),
                ('name', models.CharField(help_text='The name of this resource', max_length=512)),
                ('revoke', models.BooleanField(default=False, help_text='If a user does not meet this rule should we revoke the permission')),
                ('map_type', models.CharField(choices=[('team', 'team'), ('is_superuser', 'is_superuser'), ('is_system_auditor', 'is_system_auditor'), ('allow', 'allow'), ('organization', 'organization')], default='team', help_text='What does the map work on, a team, a user flag or is this an allow rule', max_length=17)),
                ('team', models.CharField(blank=True, default=None, help_text='A team name this rule works on', max_length=512, null=True)),
                ('organization', models.CharField(blank=True, default=None, help_text='An organization name this rule works on', max_length=512, null=True)),
                ('triggers', models.JSONField(blank=True, default=dict, help_text='Trigger information for this rule')),
                ('order', models.PositiveIntegerField(default=0, help_text='The order in which this rule should be processed, smaller numbers are of higher precedence. Items with the same order will be executed in random order')),
                ('authenticator', models.ForeignKey(help_text='The authenticator this mapping belongs to', on_delete=django.db.models.deletion.CASCADE, to='dab_authentication.authenticator')),
                ('created_by', models.ForeignKey(default=None, editable=False, help_text='The user who created this resource', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='%(app_label)s_%(class)s_created+', to=settings.AUTH_USER_MODEL)),
                ('modified_by', models.ForeignKey(default=None, editable=False, help_text='The user who last modified this resource', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='%(app_label)s_%(class)s_modified+', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='AuthenticatorUser',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.CharField(db_index=True, max_length=255)),
                ('extra_data', models.JSONField(default=dict)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('claims', models.JSONField(blank=True, default=dict)),
                ('last_login_map_results', models.JSONField(blank=True, default=list)),
                ('access_allowed', models.BooleanField(default=None, null=True)),
                ('provider', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='authenticator_user', to='dab_authentication.authenticator', to_field='slug')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='authenticator_user', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('provider', 'uid')},
            },
            bases=(models.Model, social_django.storage.DjangoUserMixin),
        ),
        migrations.AddConstraint(
            model_name='authenticatormap',
            constraint=models.CheckConstraint(check=models.Q(models.Q(('map_type', 'team'), _negated=True), models.Q(('team__isnull', False), ('organization__isnull', False)), _connector='OR'), name='dab_authentication_authenticatormap_require_org_team_if_team_map'),
        ),
        migrations.AddConstraint(
            model_name='authenticatormap',
            constraint=models.CheckConstraint(check=models.Q(models.Q(('map_type', 'organization'), _negated=True), ('organization__isnull', False), _connector='OR'), name='dab_authentication_authenticatormap_require_org_if_org_map'),
        ),
        migrations.AlterUniqueTogether(
            name='authenticatormap',
            unique_together={('name', 'authenticator')},
        ),
    ]
