"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleStack = void 0;
const lambda = require("@aws-cdk/aws-lambda");
const lambdaNodejs = require("@aws-cdk/aws-lambda-nodejs");
const cdk = require("@aws-cdk/core");
const index_1 = require("../index");
class ExampleStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const lambdaNodejsFunction = new lambdaNodejs.NodejsFunction(this, "NodeJSHandler", {
            runtime: lambda.Runtime.NODEJS_14_X,
            entry: "./src/sample/lambda_nodejs/hello_node.js",
            handler: "handler",
        });
        const datadogCDK = new index_1.Datadog(this, "Datadog", {
            nodeLayerVersion: 67,
            extensionLayerVersion: 16,
            enableDatadogTracing: true,
            flushMetricsToLogs: true,
            apiKey: process.env.API_KEY,
        });
        datadogCDK.addLambdaFunctions([lambdaNodejsFunction]);
    }
}
exports.ExampleStack = ExampleStack;
const app = new cdk.App();
const env = { account: process.env.CDK_DEFAULT_ACCOUNT, region: "sa-east-1" };
const stack = new ExampleStack(app, "CDKV2TestingExampleDatadogStack", { env: env });
console.log("Stack name: " + stack.stackName);
app.synth();
//# sourceMappingURL=data:application/json;base64,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