"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleStack = void 0;
const aws_apigateway_1 = require("@aws-cdk/aws-apigateway");
const lambda = require("@aws-cdk/aws-lambda");
const lambdaNodejs = require("@aws-cdk/aws-lambda-nodejs");
const lambdaPython = require("@aws-cdk/aws-lambda-python");
const aws_logs_1 = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
const index_1 = require("../index");
class ExampleStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const lambdaFunction = new lambda.Function(this, "HelloHandler", {
            runtime: lambda.Runtime.NODEJS_14_X,
            code: lambda.Code.fromAsset("./src/sample/lambda"),
            handler: "lambdaFunction.handler",
        });
        const lambdaNodejsFunction = new lambdaNodejs.NodejsFunction(this, "NodeJSHandler", {
            runtime: lambda.Runtime.NODEJS_14_X,
            entry: "./src/sample/lambda_nodejs/hello_node.js",
            handler: "handler",
        });
        const lambdaPythonFunction = new lambdaPython.PythonFunction(this, "PythonHandler", {
            runtime: lambda.Runtime.PYTHON_3_7,
            entry: "./src/sample/lambda/",
            index: "hello_py.py",
            handler: "handler",
        });
        // set up rest api and log group
        const restLogGroup = new aws_logs_1.LogGroup(this, "restLogGroup");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test", {
            handler: lambdaNodejsFunction,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup),
            },
        });
        const lambdaFunction1 = new lambda.Function(this, "HelloHandler1", {
            runtime: lambda.Runtime.NODEJS_14_X,
            code: lambda.Code.fromAsset("./src/sample/lambda"),
            handler: "lambdaFunction.handler",
        });
        const restLogGroup1 = new aws_logs_1.LogGroup(this, "restLogGroup1");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test1", {
            handler: lambdaFunction1,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup1),
            },
        });
        const lambdaFunction2 = new lambda.Function(this, "HelloHandler2", {
            runtime: lambda.Runtime.PYTHON_3_7,
            code: lambda.Code.fromAsset("./src/sample/lambda"),
            handler: "hello_py.handler",
            tracing: lambda.Tracing.ACTIVE,
        });
        const restLogGroup2 = new aws_logs_1.LogGroup(this, "restLogGroup2");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test2", {
            handler: lambdaPythonFunction,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup2),
            },
        });
        const datadogCDK = new index_1.Datadog(this, "Datadog", {
            nodeLayerVersion: 62,
            pythonLayerVersion: 46,
            extensionLayerVersion: 10,
            forwarderArn: "<forwarder_ARN>",
            enableDatadogTracing: true,
            flushMetricsToLogs: true,
            apiKey: "1234",
            site: "datadoghq.com",
        });
        datadogCDK.addLambdaFunctions([
            lambdaFunction,
            lambdaNodejsFunction,
            lambdaPythonFunction,
            lambdaFunction1,
            lambdaFunction2,
        ]);
        datadogCDK.addForwarderToNonLambdaLogGroups([restLogGroup, restLogGroup1, restLogGroup2]);
    }
}
exports.ExampleStack = ExampleStack;
const app = new cdk.App();
const env = { account: "<AWS_ACCOUNT>", region: "sa-east-1" };
const stack = new ExampleStack(app, "ExampleDatadogStack", { env: env });
console.log("Stack name: " + stack.stackName);
app.synth();
//# sourceMappingURL=data:application/json;base64,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