"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.addCdkConstructVersionTag = exports.Datadog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const loglevel_1 = require("loglevel");
const transport_1 = require("./common/transport");
const index_1 = require("./index");
const versionJson = require("../version.json");
/**
 * @stability stable
 */
class Datadog extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        if (((_b = process.env.DD_CONSTRUCT_DEBUG_LOGS) === null || _b === void 0 ? void 0 : _b.toLowerCase()) == "true") {
            loglevel_1.default.setLevel("debug");
        }
        super(scope, id);
        this.scope = scope;
        this.props = props;
        index_1.validateProps(this.props);
        this.transport = new transport_1.Transport(this.props.flushMetricsToLogs, this.props.site, this.props.apiKey, this.props.apiKeySecretArn, this.props.apiKmsKey, this.props.extensionLayerVersion);
    }
    /**
     * @stability stable
     */
    addLambdaFunctions(lambdaFunctions) {
        const baseProps = index_1.handleSettingPropDefaults(this.props);
        if (this.props !== undefined && lambdaFunctions.length > 0) {
            const region = `${lambdaFunctions[0].env.region}`;
            loglevel_1.default.debug(`Using region: ${region}`);
            index_1.applyLayers(this.scope, region, lambdaFunctions, this.props.pythonLayerVersion, this.props.nodeLayerVersion, this.props.extensionLayerVersion);
            index_1.redirectHandlers(lambdaFunctions, baseProps.addLayers);
            if (this.props.forwarderArn !== undefined) {
                if (this.props.extensionLayerVersion !== undefined) {
                    loglevel_1.default.debug(`Skipping adding subscriptions to the lambda log groups since the extension is enabled`);
                }
                else {
                    loglevel_1.default.debug(`Adding log subscriptions using provided Forwarder ARN: ${this.props.forwarderArn}`);
                    index_1.addForwarder(this.scope, lambdaFunctions, this.props.forwarderArn);
                }
            }
            else {
                loglevel_1.default.debug("Forwarder ARN not provided, no log group subscriptions will be added");
            }
            addCdkConstructVersionTag(lambdaFunctions);
            index_1.applyEnvVariables(lambdaFunctions, baseProps);
            this.transport.applyEnvVars(lambdaFunctions);
        }
    }
    /**
     * @stability stable
     */
    addGitCommitMetadata(lambdaFunctions, gitCommitSha) {
        index_1.setGitCommitHashEnvironmentVariable(lambdaFunctions, gitCommitSha);
    }
    /**
     * @stability stable
     */
    addForwarderToNonLambdaLogGroups(logGroups) {
        if (this.props.forwarderArn !== undefined) {
            index_1.addForwarderToLogGroups(this.scope, logGroups, this.props.forwarderArn);
        }
        else {
            loglevel_1.default.debug("Forwarder ARN not provided, no non lambda log group subscriptions will be added");
        }
    }
}
exports.Datadog = Datadog;
_a = JSII_RTTI_SYMBOL_1;
Datadog[_a] = { fqn: "datadog-cdk-constructs.Datadog", version: "0.6.0" };
function addCdkConstructVersionTag(lambdaFunctions) {
    loglevel_1.default.debug(`Adding CDK Construct version tag: ${versionJson.version}`);
    lambdaFunctions.forEach((functionName) => {
        cdk.Tags.of(functionName).add(index_1.TagKeys.CDK, `v${versionJson.version}`, {
            includeResourceTypes: ["AWS::Lambda::Function"],
        });
    });
}
exports.addCdkConstructVersionTag = addCdkConstructVersionTag;
//# sourceMappingURL=data:application/json;base64,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