import { ILambdaFunction } from "./interfaces";
export declare const API_KEY_ENV_VAR = "DD_API_KEY";
export declare const API_KEY_SECRET_ARN_ENV_VAR = "DD_API_KEY_SECRET_ARN";
export declare const KMS_API_KEY_ENV_VAR = "DD_KMS_API_KEY";
export declare const SITE_URL_ENV_VAR = "DD_SITE";
export declare const FLUSH_METRICS_TO_LOGS_ENV_VAR = "DD_FLUSH_TO_LOG";
export declare const transportDefaults: {
    site: string;
    flushMetricsToLogs: boolean;
    enableDatadogTracing: boolean;
};
/**
 * @stability stable
 */
export declare class Transport {
    /**
     * @stability stable
     */
    flushMetricsToLogs: boolean;
    /**
     * @stability stable
     */
    site: string;
    /**
     * @stability stable
     */
    apiKey?: string;
    /**
     * @stability stable
     */
    apiKeySecretArn?: string;
    /**
     * @stability stable
     */
    apiKmsKey?: string;
    /**
     * @stability stable
     */
    extensionLayerVersion?: number;
    /**
     * @stability stable
     */
    constructor(flushMetricsToLogs?: boolean, site?: string, apiKey?: string, apiKeySecretArn?: string, apiKmsKey?: string, extensionLayerVersion?: number);
    /**
     * @stability stable
     */
    applyEnvVars(lambdas: ILambdaFunction[]): void;
}
