"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyEnvVariables = exports.setGitCommitHashEnvironmentVariable = exports.DD_TAGS = exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR = exports.ENABLE_DD_LOGS_ENV_VAR = exports.LOG_LEVEL_ENV_VAR = exports.INJECT_LOG_CONTEXT_ENV_VAR = exports.ENABLE_DD_TRACING_ENV_VAR = void 0;
const loglevel_1 = require("loglevel");
exports.ENABLE_DD_TRACING_ENV_VAR = "DD_TRACE_ENABLED";
exports.INJECT_LOG_CONTEXT_ENV_VAR = "DD_LOGS_INJECTION";
exports.LOG_LEVEL_ENV_VAR = "DD_LOG_LEVEL";
exports.ENABLE_DD_LOGS_ENV_VAR = "DD_SERVERLESS_LOGS_ENABLED";
exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR = "DD_CAPTURE_LAMBDA_PAYLOAD";
exports.DD_TAGS = "DD_TAGS";
function setGitCommitHashEnvironmentVariable(lambdas, hash) {
    lambdas.forEach((lambda) => {
        lambda.addEnvironment(exports.DD_TAGS, "git.commit.sha:" + hash);
    });
}
exports.setGitCommitHashEnvironmentVariable = setGitCommitHashEnvironmentVariable;
function applyEnvVariables(lambdas, baseProps) {
    loglevel_1.default.debug(`Setting environment variables...`);
    lambdas.forEach((lam) => {
        lam.addEnvironment(exports.ENABLE_DD_TRACING_ENV_VAR, baseProps.enableDatadogTracing.toString().toLowerCase());
        lam.addEnvironment(exports.INJECT_LOG_CONTEXT_ENV_VAR, baseProps.injectLogContext.toString().toLowerCase());
        lam.addEnvironment(exports.ENABLE_DD_LOGS_ENV_VAR, baseProps.enableDatadogLogs.toString().toLowerCase());
        lam.addEnvironment(exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR, baseProps.captureLambdaPayload.toString().toLowerCase());
        if (baseProps.logLevel) {
            lam.addEnvironment(exports.LOG_LEVEL_ENV_VAR, baseProps.logLevel);
        }
    });
}
exports.applyEnvVariables = applyEnvVariables;
//# sourceMappingURL=data:application/json;base64,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