"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.govCloudRegions = exports.runtimeToLayerName = exports.runtimeLookup = exports.TagKeys = exports.DefaultDatadogProps = exports.RuntimeType = exports.SUBSCRIPTION_FILTER_PREFIX = exports.JS_HANDLER = exports.JS_HANDLER_WITH_LAYERS = exports.PYTHON_HANDLER = exports.DD_HANDLER_ENV_VAR = exports.DD_GOV_ACCOUNT_ID = exports.DD_ACCOUNT_ID = exports.EXTENSION_LAYER_PREFIX = exports.LAYER_PREFIX = void 0;
exports.LAYER_PREFIX = "DatadogLayer";
exports.EXTENSION_LAYER_PREFIX = "DatadogExtension";
exports.DD_ACCOUNT_ID = "464622532012";
exports.DD_GOV_ACCOUNT_ID = "002406178527";
exports.DD_HANDLER_ENV_VAR = "DD_LAMBDA_HANDLER";
exports.PYTHON_HANDLER = "datadog_lambda.handler.handler";
exports.JS_HANDLER_WITH_LAYERS = "/opt/nodejs/node_modules/datadog-lambda-js/handler.handler";
exports.JS_HANDLER = "node_modules/datadog-lambda-js/dist/handler.handler";
exports.SUBSCRIPTION_FILTER_PREFIX = "DatadogSubscriptionFilter";
/**
 * @stability stable
 */
var RuntimeType;
(function (RuntimeType) {
    RuntimeType[RuntimeType["NODE"] = 0] = "NODE";
    RuntimeType[RuntimeType["PYTHON"] = 1] = "PYTHON";
    RuntimeType[RuntimeType["UNSUPPORTED"] = 2] = "UNSUPPORTED";
})(RuntimeType = exports.RuntimeType || (exports.RuntimeType = {}));
exports.DefaultDatadogProps = {
    addLayers: true,
    enableDatadogTracing: true,
    injectLogContext: true,
    enableDatadogLogs: true,
    architecture: "X86_64",
    captureLambdaPayload: false,
};
var TagKeys;
(function (TagKeys) {
    TagKeys["CDK"] = "dd_cdk_construct";
})(TagKeys = exports.TagKeys || (exports.TagKeys = {}));
exports.runtimeLookup = {
    "nodejs12.x": RuntimeType.NODE,
    "nodejs14.x": RuntimeType.NODE,
    "python3.6": RuntimeType.PYTHON,
    "python3.7": RuntimeType.PYTHON,
    "python3.8": RuntimeType.PYTHON,
    "python3.9": RuntimeType.PYTHON,
};
exports.runtimeToLayerName = {
    "nodejs12.x": "Datadog-Node12-x",
    "nodejs14.x": "Datadog-Node14-x",
    "python3.6": "Datadog-Python36",
    "python3.7": "Datadog-Python37",
    "python3.8": "Datadog-Python38",
    "python3.9": "Datadog-Python39",
};
exports.govCloudRegions = ["us-gov-east-1", "us-gov-west-1"];
//# sourceMappingURL=data:application/json;base64,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