# Generated by Django 2.0.6 on 2018-06-24 20:59

import uuid

import ckeditor.fields
from django.db import migrations, models
import django.db.models.deletion
import enumfields.fields

from antares.apps.core.constants import *

from ..constants import *


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ActivityApplicationDefinition',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('scope', enumfields.fields.EnumField(default='Same', enum=ActivityApplicationDefinitionScopeType, max_length=30)),
                ('description', models.CharField(blank=True, max_length=1000, null=True)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.activity_application_definition.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.activity_application_definition.table_name_plural',
                'db_table': 'flow_activity_application_definition',
            },
        ),
        migrations.CreateModel(
            name='ActivityApplicationParameterDefinition',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('content', models.CharField(blank=True, max_length=2000, null=True)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.activity_application_parameter_definition.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.activity_application_parameter_definition.table_name_plural',
                'db_table': 'flow_activity_application_parameter_definition',
            },
        ),
        migrations.CreateModel(
            name='ActivityDefinition',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('activity_id', models.CharField(max_length=255)),
                ('activity_type', enumfields.fields.EnumField(enum=ActivityType, max_length=30)),
                ('assignment_strategy', enumfields.fields.EnumField(blank=True, enum=AssignmentStrategyType, max_length=30, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('display_name', models.CharField(blank=True, max_length=255, null=True)),
                ('finish_mode', enumfields.fields.EnumField(enum=ExecutionModeType, max_length=30)),
                ('hrn_script', models.CharField(blank=True, max_length=2000, null=True)),
                ('start_mode', enumfields.fields.EnumField(enum=ExecutionModeType, max_length=30)),
                ('property_strategy_definition', models.CharField(blank=True, max_length=100, null=True)),
                ('activity_strategy_definition', models.CharField(blank=True, max_length=100, null=True)),
                ('instantiation', enumfields.fields.EnumField(blank=True, enum=FlowActivityInstantiationType, max_length=10, null=True)),
                ('cost', models.FloatField(blank=True, null=True)),
                ('waiting_time', models.FloatField(blank=True, null=True)),
                ('working_time', models.FloatField(blank=True, null=True)),
                ('duration', models.FloatField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.activity_definition.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.activity_definition.table_name_plural',
                'db_table': 'flow_activity_definition',
            },
        ),
        migrations.CreateModel(
            name='ActivityLog',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('activity_id', models.CharField(max_length=255)),
                ('contents', models.TextField(blank=True, null=True)),
                ('status', enumfields.fields.EnumField(enum=FlowActivityStatusType, max_length=30)),
                ('status_date', models.DateTimeField()),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.operation.activity_log.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.operation.activity_log.table_name_plural',
                'db_table': 'flow_activity_log',
            },
        ),
        migrations.CreateModel(
            name='ApplicationDefinition',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('application_id', models.CharField(blank=True, max_length=100, null=True)),
                ('definition_site', enumfields.fields.EnumField(enum=DefinitionSiteType, max_length=30)),
                ('description', models.TextField(blank=True, null=True)),
                ('application_name', models.CharField(blank=True, max_length=100, null=True)),
                ('url', models.CharField(blank=True, max_length=255, null=True)),
                ('route', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.application_definition.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.application_definition.table_name_plural',
                'db_table': 'flow_application_definition',
            },
        ),
        migrations.CreateModel(
            name='ApplicationParameterDefinition',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('data_type', enumfields.fields.EnumField(enum=FlowDataType, max_length=30)),
                ('definition_site', enumfields.fields.EnumField(enum=DefinitionSiteType, max_length=30)),
                ('display_name', models.CharField(blank=True, max_length=200, null=True)),
                ('initial_value', models.CharField(blank=True, max_length=255, null=True)),
                ('length', models.IntegerField(blank=True, null=True)),
                ('order_number', models.IntegerField(blank=True, null=True)),
                ('parameter_id', models.CharField(max_length=200)),
                ('property_type', enumfields.fields.EnumField(enum=PropertyType, max_length=30)),
                ('sub_data_type', enumfields.fields.EnumField(blank=True, enum=FieldDataType, max_length=30, null=True)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.application_parameter_definition.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.application_parameter_definition.table_name_plural',
                'db_table': 'flow_application_parameter_definition',
            },
        ),
        migrations.CreateModel(
            name='AssignmentList',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('assigment_strategy', enumfields.fields.EnumField(enum=AssignmentStrategyType, max_length=30)),
                ('creation_date', models.DateTimeField()),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.operation.assignment_list.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.operation.assignment_list.table_name_plural',
                'db_table': 'flow_assignment_list',
            },
        ),
        migrations.CreateModel(
            name='FlowActionDefinition',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('action_type', enumfields.fields.EnumField(default='Postaction', enum=ActionType, max_length=30)),
                ('script_engine', enumfields.fields.EnumField(enum=ScriptEngineType, max_length=30)),
                ('content', models.CharField(blank=True, max_length=2000, null=True)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.flow_action_definition.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.flow_action_definition.table_name_plural',
                'db_table': 'flow_action_definition',
            },
        ),
        migrations.CreateModel(
            name='FlowActionDefinitionParameterMap',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('content', models.CharField(blank=True, max_length=2000, null=True)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.flow_action_definition_parameter_map.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.flow_action_definition_parameter_map.table_name_plural',
                'db_table': 'flow_action_definition_parameter_definition',
            },
        ),
        migrations.CreateModel(
            name='FlowActivity',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('activity_number', models.CharField(blank=True, max_length=255, null=True)),
                ('completion_date', models.DateTimeField(blank=True, null=True)),
                ('creation_date', models.DateTimeField()),
                ('start_date', models.DateTimeField(blank=True, null=True)),
                ('status', enumfields.fields.EnumField(enum=FlowActivityStatusType, max_length=30)),
                ('status_date', models.DateTimeField()),
                ('hrn_code', models.CharField(help_text='antares.apps.flow.models.operation.flow_activity.hrn_code_help', max_length=50, unique=True, verbose_name='antares.apps.flow.models.operation.flow_activity.hrn_code')),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.operation.flow_activity.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.operation.flow_activity.table_name_plural',
                'db_table': 'flow_activity',
            },
        ),
        migrations.CreateModel(
            name='FlowActivityExtraTab',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('tab_name', models.CharField(blank=True, max_length=2000, null=True)),
                ('tab_id', models.CharField(max_length=200)),
                ('route', models.CharField(blank=True, max_length=200, null=True)),
                ('url', models.CharField(blank=True, max_length=200, null=True)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.flow_activity_extra_tab.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.flow_activity_extra_tab.table_name_plural',
                'db_table': 'flow_activity_extra_tab',
            },
        ),
        migrations.CreateModel(
            name='FlowActivityExtraTabParameter',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('param_id', models.CharField(max_length=200)),
                ('value', models.CharField(max_length=200)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.flow_activity_extra_tab_parameter.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.flow_activity_extra_tab_parameter.table_name_plural',
                'db_table': 'flow_activity_extra_tab_parameter',
            },
        ),
        migrations.CreateModel(
            name='FlowActivityForm',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('can_save', models.BooleanField(default=False)),
                ('can_create', models.BooleanField(default=False)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.flow_activity_form.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.flow_activity_form.table_name_plural',
                'db_table': 'flow_activity_form',
            },
        ),
        migrations.CreateModel(
            name='FlowActivityFormParameter',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('param_id', models.CharField(max_length=200)),
                ('value', models.CharField(max_length=200)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.flow_activity_form_parameter.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.flow_activity_form_parameter.table_name_plural',
                'db_table': 'flow_activity_form_parameter',
            },
        ),
        migrations.CreateModel(
            name='FlowActivityValidation',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('validation_id', models.CharField(max_length=2000)),
                ('validation', models.CharField(max_length=2000)),
                ('message', models.CharField(max_length=2000)),
                ('script_type', enumfields.fields.EnumField(default='Javascript', enum=ScriptEngineType, max_length=30)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.flow_activity_validation.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.flow_activity_validation.table_name_plural',
                'db_table': 'flow_activity_validation',
            },
        ),
        migrations.CreateModel(
            name='FlowAttachment',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('content', models.BinaryField()),
                ('file_name', models.CharField(max_length=400)),
                ('mime_type', models.CharField(max_length=100)),
                ('post_date', models.DateTimeField()),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.operation.flow_attachment.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.operation.flow_attachment.table_name_plural',
                'db_table': 'flow_attachment',
            },
        ),
        migrations.CreateModel(
            name='FlowCase',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('case_name', models.CharField(blank=True, max_length=255, null=True)),
                ('case_number', models.CharField(blank=True, max_length=255, null=True)),
                ('completion_date', models.DateTimeField(blank=True, null=True)),
                ('creation_date', models.DateTimeField()),
                ('priority', models.CharField(max_length=30)),
                ('start_date', models.DateTimeField(blank=True, null=True)),
                ('status', enumfields.fields.EnumField(enum=FlowCaseStatusType, max_length=30)),
                ('hrn_code', models.CharField(help_text='antares.apps.flow.models.operation.flow_case.hrn_code_help', max_length=50, unique=True, verbose_name='antares.apps.flow.models.operation.flow_case.hrn_code')),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.operation.flow_case.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.operation.flow_case.table_name_plural',
                'db_table': 'flow_case',
            },
        ),
        migrations.CreateModel(
            name='FlowDefinition',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('access_level', models.CharField(max_length=7)),
                ('creation_date', models.DateTimeField()),
                ('description', models.TextField(blank=True, null=True)),
                ('display_name', models.CharField(blank=True, max_length=200, null=True)),
                ('flow_id', models.CharField(blank=True, max_length=255, null=True)),
                ('flow_name', models.CharField(blank=True, max_length=255, null=True)),
                ('flow_version', models.CharField(blank=True, max_length=255, null=True)),
                ('hrn_script', models.CharField(blank=True, max_length=2000, null=True)),
                ('update_date', models.DateTimeField(blank=True, null=True)),
                ('status', enumfields.fields.EnumField(enum=FlowDefinitionStatusType, max_length=30)),
                ('valid_from', models.DateTimeField(blank=True, null=True)),
                ('valid_to', models.DateTimeField(blank=True, null=True)),
                ('time_unit', enumfields.fields.EnumField(blank=True, enum=TimeUnitType, max_length=10, null=True)),
                ('waiting_time', models.FloatField(blank=True, null=True)),
                ('working_time', models.FloatField(blank=True, null=True)),
                ('duration', models.FloatField(blank=True, null=True)),
                ('priority', enumfields.fields.EnumField(blank=True, enum=FlowPriorityType, max_length=10, null=True)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.flow_definition.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.flow_definition.table_name_plural',
                'db_table': 'flow_definition',
            },
        ),
        migrations.CreateModel(
            name='FlowDocument',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('creation_date', models.DateTimeField()),
                ('update_date', models.DateTimeField()),
                ('relationship', enumfields.fields.EnumField(enum=FlowDocumentRelationshipType, max_length=30)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.operation.flow_document.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.operation.flow_document.table_name_plural',
                'db_table': 'flow_document',
            },
        ),
        migrations.CreateModel(
            name='FlowNote',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('content', ckeditor.fields.RichTextField(blank=True, null=True)),
                ('post_date', models.DateTimeField(blank=True, null=True)),
                ('update_date', models.DateTimeField(blank=True, null=True)),
                ('title', models.CharField(blank=True, max_length=2000, null=True)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.operation.flow_note.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.operation.flow_note.table_name_plural',
                'db_table': 'flow_note',
            },
        ),
        migrations.CreateModel(
            name='FlowPackage',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('creation_date', models.DateTimeField()),
                ('update_date', models.DateTimeField(blank=True, null=True)),
                ('package_id', models.CharField(max_length=100)),
                ('package_name', models.CharField(max_length=100)),
                ('package_version', models.CharField(max_length=30)),
                ('xpdl', models.TextField()),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.flow_package.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.flow_package.table_name_plural',
                'db_table': 'flow_package',
            },
        ),
        migrations.CreateModel(
            name='FlowProperty',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('clob_value', models.BinaryField(blank=True, null=True)),
                ('data_type', enumfields.fields.EnumField(enum=FlowDataType, max_length=30)),
                ('date_value', models.DateTimeField(blank=True, null=True)),
                ('decimal_value', models.DecimalField(blank=True, decimal_places=2, max_digits=19, null=True)),
                ('integer_value', models.BigIntegerField(blank=True, null=True)),
                ('property_id', models.CharField(max_length=100)),
                ('string_value', models.CharField(blank=True, max_length=2000, null=True)),
                ('sub_data_type', enumfields.fields.EnumField(enum=FlowBasicDataSubtype, max_length=30)),
                ('text_value', models.TextField(blank=True, null=True)),
                ('boolean_value', models.NullBooleanField()),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.operation.flow_property.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.operation.flow_property.table_name_plural',
                'db_table': 'flow_property',
            },
        ),
        migrations.CreateModel(
            name='FlowUserNotificationOption',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('active', models.BooleanField(default=False)),
                ('creation_date', models.DateTimeField(blank=True, null=True)),
                ('update_date', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.operation.flow_user_notification_option.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.operation.flow_user_notification_option.table_name_plural',
                'db_table': 'flow_user_notification_option',
            },
        ),
        migrations.CreateModel(
            name='ParticipantDefinition',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('definition_site', models.CharField(max_length=7)),
                ('participant_id', models.CharField(max_length=255)),
                ('participant_name', models.CharField(blank=True, max_length=255, null=True)),
                ('participant_type', enumfields.fields.EnumField(enum=ParticipantType, max_length=30)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.participant_definition.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.participant_definition.table_name_plural',
                'db_table': 'flow_participant_definition',
            },
        ),
        migrations.CreateModel(
            name='PropertyDefinition',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('data_type', enumfields.fields.EnumField(enum=FlowDataType, max_length=30)),
                ('definition_site', models.CharField(max_length=7)),
                ('display_name', models.CharField(blank=True, max_length=200, null=True)),
                ('initial_value', models.CharField(blank=True, max_length=255, null=True)),
                ('length', models.IntegerField(blank=True, null=True)),
                ('property_id', models.CharField(max_length=200)),
                ('property_type', enumfields.fields.EnumField(enum=PropertyType, max_length=30)),
                ('script_engine', enumfields.fields.EnumField(enum=ScriptEngineType, max_length=30)),
                ('sub_data_type', enumfields.fields.EnumField(blank=True, enum=FieldDataType, max_length=30, null=True)),
                ('mode', enumfields.fields.EnumField(blank=True, enum=FormalParameterModeType, max_length=30, null=True)),
                ('catalog', models.CharField(blank=True, max_length=200, null=True)),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.property_definition.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.property_definition.table_name_plural',
                'db_table': 'flow_property_definition',
            },
        ),
        migrations.CreateModel(
            name='ReassigmentLog',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('original_date', models.DateTimeField()),
                ('reason', ckeditor.fields.RichTextField()),
                ('reassigment_date', models.DateTimeField()),
                ('creation_date', models.DateTimeField()),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.operation.reassigment_log.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.operation.reassigment_log.table_name_plural',
                'db_table': 'flow_reassignment_log',
            },
        ),
        migrations.CreateModel(
            name='TransitionDefinition',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('condition_text', models.TextField(blank=True, null=True)),
                ('transition_id', models.CharField(max_length=255)),
                ('transition_name', models.CharField(blank=True, max_length=255, null=True)),
                ('transition_type', enumfields.fields.EnumField(enum=TransitionType, max_length=30)),
                ('flow_definition', models.ForeignKey(blank=True, db_column='flow_definition', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='transition_definition_set', to='flow.FlowDefinition')),
                ('from_activity_definition', models.ForeignKey(blank=True, db_column='from_activity_definition', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='transition_definition_from_activity_set', to='flow.ActivityDefinition')),
                ('to_activity_definition', models.ForeignKey(blank=True, db_column='to_activity_definition', null=True, on_delete=django.db.models.deletion.PROTECT, related_name='transition_definition_to_activity_set', to='flow.ActivityDefinition')),
            ],
            options={
                'verbose_name': 'antares.apps.flow.models.definition.transition_definition.table_name',
                'verbose_name_plural': 'antares.apps.flow.models.definition.transition_definition.table_name_plural',
                'db_table': 'flow_transition_definition',
            },
        ),
    ]
