'''
Created on 21/8/2016

@author: leobelen
'''
import logging

from braces.views import AjaxResponseMixin, JSONResponseMixin
from django.views.generic import View

from antares.apps.core.models.catalog import Catalog


logger = logging.getLogger(__name__)


class ApiAutocompleteView(AjaxResponseMixin, JSONResponseMixin, View):
    def get(self, request, *args, **kwargs):
        if 'selector' in request.GET:
            if 'q' in request.GET:
                element_list = Catalog.find_list_by_catalog_id(
                    request.GET.get('selector'), request.GET.get('q'))
            else:
                element_list = Catalog.find_list_by_catalog_id(
                    request.GET.get('selector'))
        return self.render_json_response(element_list)
