# Copyright 2021 IRT Saint Exupéry, https://www.irt-saintexupery.com
#
# This work is licensed under a BSD 0-Clause License.
#
# Permission to use, copy, modify, and/or distribute this software
# for any purpose with or without fee is hereby granted.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT,
# OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
# Contributors:
#    INITIAL AUTHORS - initial API and implementation and/or initial
#                           documentation
#        :author: Matthias De Lozzo
#    OTHER AUTHORS   - MACROSCOPIC CHANGES
"""
Plot - ZvsXY
============

"""
from gemseo.api import configure_logger
from gemseo.api import load_dataset
from gemseo.post.dataset.zvsxy import ZvsXY
from matplotlib import pyplot as plt

configure_logger()


############################################################################
# Load the Rosenbrock dataset
# ---------------------------
dataset = load_dataset("RosenbrockDataset")

############################################################################
# Plot z vs x and y
# -----------------
# We can use the :class:`.ZvsXY` plot
plot = ZvsXY(dataset, x="x", x_comp=0, y="x", y_comp=1, z="rosen")
plot.colormap = "viridis"
plot.execute(save=False, show=False)
# Workaround for HTML rendering, instead of ``show=True``
plt.show()
