"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrailLogging = exports.TrailLoggingProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const actiontrail_generated_1 = require("./actiontrail.generated");
Object.defineProperty(exports, "TrailLoggingProperty", { enumerable: true, get: function () { return actiontrail_generated_1.RosTrailLogging; } });
/**
 * A ROS resource type:  `ALIYUN::ACTIONTRAIL::TrailLogging`
 */
class TrailLogging extends ros.Resource {
    /**
     * Create a new `ALIYUN::ACTIONTRAIL::TrailLogging`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTrailLogging = new actiontrail_generated_1.RosTrailLogging(this, id, {
            enable: props.enable,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTrailLogging;
        this.attrIsLogging = rosTrailLogging.attrIsLogging;
        this.attrLatestDeliveryError = rosTrailLogging.attrLatestDeliveryError;
        this.attrLatestDeliveryTime = rosTrailLogging.attrLatestDeliveryTime;
        this.attrStartLoggingTime = rosTrailLogging.attrStartLoggingTime;
        this.attrStopLoggingTime = rosTrailLogging.attrStopLoggingTime;
    }
}
exports.TrailLogging = TrailLogging;
//# sourceMappingURL=data:application/json;base64,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