"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Trail = exports.TrailProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const actiontrail_generated_1 = require("./actiontrail.generated");
Object.defineProperty(exports, "TrailProperty", { enumerable: true, get: function () { return actiontrail_generated_1.RosTrail; } });
/**
 * A ROS resource type:  `ALIYUN::ACTIONTRAIL::Trail`
 */
class Trail extends ros.Resource {
    /**
     * Create a new `ALIYUN::ACTIONTRAIL::Trail`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTrail = new actiontrail_generated_1.RosTrail(this, id, {
            slsProjectArn: props.slsProjectArn,
            roleName: props.roleName,
            eventRw: props.eventRw === undefined || props.eventRw === null ? 'Write' : props.eventRw,
            ossKeyPrefix: props.ossKeyPrefix,
            ossBucketName: props.ossBucketName,
            slsWriteRoleArn: props.slsWriteRoleArn,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTrail;
        this.attrName = rosTrail.attrName;
    }
}
exports.Trail = Trail;
//# sourceMappingURL=data:application/json;base64,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