# pyhstr

![build status](https://github.com/adder46/pyhstr/workflows/pyhstr/badge.svg) [![codecov](https://codecov.io/gh/adder46/pyhstr/branch/master/graph/badge.svg?token=ZMY0VUX8WS)](https://codecov.io/gh/adder46/pyhstr)

Inspired by hstr, **pyhstr** is a history suggest box that lets you quickly search, navigate, and manage your Python shell history. At this point, it supports the standard Python shell, IPython, and bpython. The plan is to support ptpython as well, but some help is needed for that to happen (see [issue #7](https://github.com/adder46/pyhstr/issues/7)).

## Installation


```
pip install pyhstr
```

## Usage

The **standard** shell and **bpython**:

  ```python
  >>> from pyhstr import hh
  >>> hh
  ```

**IPython**:

  ```ipython
  In [1]: import pyhstr
  In [2]: %hh
  ```

Making an alias should be more convenient though, for example:

```bash
alias py='python3 -ic "from pyhstr import hh"'
```

## Screencast

![screenshot](pyhstr.gif)

## Development

You will need [poetry](https://github.com/python-poetry/poetry), preferably with these options in config:

```toml
virtualenvs.create = true
virtualenvs.in-project = true
```

Then clone the repo, cd into it, make a venv, activate it, and install the project:

```sh
git clone https://github.com/adder46/pyhstr
cd pyhstr
poetry env use python3
. .venv/bin/activate
poetry install
```

To run tests, mypy checks, and style checks, you need to have Pythons:

- 3.7
- 3.8
- 3.9

For installing all the Python versions, I recommend [pyenv](https://github.com/pyenv/pyenv).

Once you have them, run:

```
tox
```

## Licensing

Licensed under the [MIT License](https://opensource.org/licenses/MIT). For details, see [LICENSE](https://github.com/adder46/pyhstr/blob/master/LICENSE).