/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class OutputReader
extends Thread {
    private static final int BUFFER_SIZE = 1024;
    private final InputStream source;
    private ByteBuffer buffer;
    private boolean finished = false;

    public OutputReader(InputStream source) {
        if (source == null) {
            throw new IllegalArgumentException("Source stream may not be null");
        }
        this.source = source;
        this.buffer = ByteBuffer.allocate(1024);
        this.setDaemon(true);
        this.setName("Output reader");
        this.start();
    }

    private synchronized void setFinished() {
        this.finished = true;
        this.notifyAll();
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitUntilFinished() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException t) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private synchronized void addToBuffer(byte[] bytes, int length) {
        while (this.buffer.remaining() < length) {
            ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity() * 2);
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
        this.buffer.put(bytes, 0, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] bytes = new byte[1024];
        try {
            while (true) {
                int readCount;
                if ((readCount = this.source.read(bytes)) < 0) {
                    return;
                }
                this.addToBuffer(bytes, readCount);
                continue;
                break;
            }
        }
        catch (Exception e) {
            return;
        }
        finally {
            try {
                this.source.close();
            }
            catch (IOException iOException) {}
            this.setFinished();
        }
    }

    public synchronized String getResultAsString() {
        this.waitUntilFinished();
        return new String(this.buffer.array(), 0, this.buffer.position(), StandardCharsets.UTF_8);
    }

    public synchronized byte[] getResult() {
        this.waitUntilFinished();
        return Arrays.copyOfRange(this.buffer.array(), 0, this.buffer.position());
    }
}

