/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.ssh;

import java.util.Map;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.XenonPropertyDescription;
import nl.esciencecenter.xenon.adaptors.XenonProperties;
import nl.esciencecenter.xenon.adaptors.schedulers.JobQueueScheduler;
import nl.esciencecenter.xenon.adaptors.schedulers.SchedulerAdaptor;
import nl.esciencecenter.xenon.adaptors.schedulers.ssh.SshInteractiveProcessFactory;
import nl.esciencecenter.xenon.adaptors.shared.ssh.SSHUtil;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.schedulers.Scheduler;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshSchedulerAdaptor
extends SchedulerAdaptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshSchedulerAdaptor.class);
    public static final String ADAPTOR_NAME = "ssh";
    public static final int DEFAULT_PORT = 22;
    public static final String ADAPTOR_DESCRIPTION = "The SSH job adaptor implements all functionality to start jobs on ssh servers.";
    public static final String[] ADAPTOR_LOCATIONS = new String[]{"host[:port][/workdir]"};
    public static final String PREFIX = "xenon.adaptors.schedulers.ssh.";
    public static final String STRICT_HOST_KEY_CHECKING = "xenon.adaptors.schedulers.ssh.strictHostKeyChecking";
    public static final String AGENT = "xenon.adaptors.schedulers.ssh.agent";
    public static final String AGENT_FORWARDING = "xenon.adaptors.schedulers.ssh.agentForwarding";
    public static final String LOAD_STANDARD_KNOWN_HOSTS = "xenon.adaptors.schedulers.ssh.loadKnownHosts";
    public static final String LOAD_SSH_CONFIG = "xenon.adaptors.schedulers.ssh.loadSshConfig";
    public static final String SSH_CONFIG_FILE = "xenon.adaptors.schedulers.ssh.sshConfigFile";
    public static final String AUTOMATICALLY_ADD_HOST_KEY = "xenon.adaptors.schedulers.ssh.autoAddHostKey";
    public static final String GATEWAY = "xenon.adaptors.schedulers.ssh.gateway";
    public static final String TIMEOUT = "xenon.adaptors.schedulers.ssh.timeout";
    public static final String QUEUE = "xenon.adaptors.schedulers.ssh.queue.";
    public static final String MAX_HISTORY = "xenon.adaptors.schedulers.ssh.queue.historySize";
    public static final String POLLING_DELAY = "xenon.adaptors.schedulers.ssh.queue.pollingDelay";
    public static final String MULTIQ = "xenon.adaptors.schedulers.ssh.queue.multi.";
    public static final String MULTIQ_MAX_CONCURRENT = "xenon.adaptors.schedulers.ssh.queue.multi.maxConcurrentJobs";
    public static final String INFO = "xenon.adaptors.schedulers.ssh.info.";
    public static final String JOBS = "xenon.adaptors.schedulers.ssh.info.jobs.";
    public static final String SUBMITTED = "xenon.adaptors.schedulers.ssh.info.jobs.submitted";
    public static final XenonPropertyDescription[] VALID_PROPERTIES = new XenonPropertyDescription[]{new XenonPropertyDescription("xenon.adaptors.schedulers.ssh.autoAddHostKey", XenonPropertyDescription.Type.BOOLEAN, "true", "Automatically add unknown host keys to known_hosts."), new XenonPropertyDescription("xenon.adaptors.schedulers.ssh.strictHostKeyChecking", XenonPropertyDescription.Type.BOOLEAN, "true", "Enable strict host key checking."), new XenonPropertyDescription("xenon.adaptors.schedulers.ssh.loadKnownHosts", XenonPropertyDescription.Type.BOOLEAN, "true", "Load the standard known_hosts file."), new XenonPropertyDescription("xenon.adaptors.schedulers.ssh.loadSshConfig", XenonPropertyDescription.Type.BOOLEAN, "true", "Load the OpenSSH config file."), new XenonPropertyDescription("xenon.adaptors.schedulers.ssh.sshConfigFile", XenonPropertyDescription.Type.STRING, null, "OpenSSH config filename."), new XenonPropertyDescription("xenon.adaptors.schedulers.ssh.agent", XenonPropertyDescription.Type.BOOLEAN, "false", "Use a (local) ssh-agent."), new XenonPropertyDescription("xenon.adaptors.schedulers.ssh.agentForwarding", XenonPropertyDescription.Type.BOOLEAN, "false", "Use ssh-agent forwarding"), new XenonPropertyDescription("xenon.adaptors.schedulers.ssh.timeout", XenonPropertyDescription.Type.LONG, "10000", "The timeout for the connection setup and authetication (in milliseconds)."), new XenonPropertyDescription("xenon.adaptors.schedulers.ssh.queue.pollingDelay", XenonPropertyDescription.Type.LONG, "1000", "The polling delay for monitoring running jobs (in milliseconds)."), new XenonPropertyDescription("xenon.adaptors.schedulers.ssh.queue.multi.maxConcurrentJobs", XenonPropertyDescription.Type.INTEGER, "4", "The maximum number of concurrent jobs in the multiq.."), new XenonPropertyDescription("xenon.adaptors.schedulers.ssh.gateway", XenonPropertyDescription.Type.STRING, null, "The gateway machine used to create an SSH tunnel to the target.")};

    public SshSchedulerAdaptor() {
        super(ADAPTOR_NAME, ADAPTOR_DESCRIPTION, ADAPTOR_LOCATIONS, VALID_PROPERTIES);
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public boolean supportsInteractive() {
        return true;
    }

    @Override
    public Scheduler createScheduler(String location, Credential credential, Map<String, String> properties) throws XenonException {
        LOGGER.debug("new SSH scheduler location = {} credential = {} properties = {}", new Object[]{location, credential, properties});
        XenonProperties xp = new XenonProperties(VALID_PROPERTIES, properties);
        boolean loadSSHConfig = xp.getBooleanProperty(LOAD_SSH_CONFIG);
        boolean strictHostCheck = xp.getBooleanProperty(STRICT_HOST_KEY_CHECKING);
        boolean addHostKey = xp.getBooleanProperty(AUTOMATICALLY_ADD_HOST_KEY);
        boolean useSSHAgent = xp.getBooleanProperty(AGENT);
        boolean useAgentForwarding = xp.getBooleanProperty(AGENT_FORWARDING);
        SshClient client = SSHUtil.createSSHClient(loadSSHConfig, strictHostCheck, addHostKey, useSSHAgent, useAgentForwarding);
        long timeout = xp.getLongProperty(TIMEOUT);
        ClientSession session = SSHUtil.connect(ADAPTOR_NAME, client, location, credential, timeout);
        Map<String, String> sftpProperties = SSHUtil.sshToSftpProperties(properties);
        FileSystem fs = FileSystem.create("sftp", location, credential, sftpProperties);
        long pollingDelay = xp.getLongProperty(POLLING_DELAY);
        int multiQThreads = xp.getIntegerProperty(MULTIQ_MAX_CONCURRENT);
        return new JobQueueScheduler(this.getNewUniqueID(), ADAPTOR_NAME, location, new SshInteractiveProcessFactory(session), fs, fs.getWorkingDirectory(), multiQThreads, pollingDelay, timeout, xp);
    }
}

