/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.ssh;

import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.InteractiveProcess;
import nl.esciencecenter.xenon.adaptors.schedulers.InteractiveProcessFactory;
import nl.esciencecenter.xenon.adaptors.schedulers.SchedulerClosedException;
import nl.esciencecenter.xenon.adaptors.schedulers.ssh.SshInteractiveProcess;
import nl.esciencecenter.xenon.schedulers.JobDescription;
import org.apache.sshd.client.session.ClientSession;

public class SshInteractiveProcessFactory
implements InteractiveProcessFactory {
    private final ClientSession session;

    protected SshInteractiveProcessFactory(ClientSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Session may not be null");
        }
        this.session = session;
    }

    @Override
    public InteractiveProcess createInteractiveProcess(JobDescription description, String jobIdentifier, long timeoutInMillis) throws XenonException {
        if (this.session.isClosed()) {
            throw new SchedulerClosedException("ssh", "Scheduler is closed");
        }
        return new SshInteractiveProcess(this.session, description, jobIdentifier, timeoutInMillis);
    }

    @Override
    public void close() throws XenonException {
        if (this.session.isClosed()) {
            throw new SchedulerClosedException("ssh", "Scheduler already closed");
        }
        try {
            this.session.close();
        }
        catch (Exception e) {
            throw new XenonException("ssh", "Scheduler failed to close", e);
        }
    }

    @Override
    public boolean isOpen() throws XenonException {
        return this.session.isOpen();
    }
}

