/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.slurm;

import java.util.Map;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.slurm.SlurmSchedulerAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlurmSetup {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlurmSetup.class);
    private final boolean accountingAvailable;
    private final String version;

    SlurmSetup(Map<String, String> info, boolean disableAccounting) throws XenonException {
        String accountingType;
        this.version = info.get("SLURM_VERSION");
        if (this.version == null) {
            throw new XenonException("slurm", "Slurm config does not contain version info");
        }
        if (!this.checkVersion()) {
            LOGGER.warn("Slurm version {} not officially supported by Slurm Adaptor.", (Object)this.version);
        }
        if ((accountingType = info.get("AccountingStorageType")) == null) {
            throw new XenonException("slurm", "Slurm config does not contain expected accounting info");
        }
        this.accountingAvailable = !accountingType.equals("accounting_storage/none") && !disableAccounting;
        LOGGER.debug("Created new SlurmConfig. version = \"{}\", accounting available: {}", (Object)this.version, (Object)this.accountingAvailable);
    }

    public boolean checkVersion() {
        for (String supportedVersion : SlurmSchedulerAdaptor.SUPPORTED_VERSIONS) {
            if (!this.version.startsWith(supportedVersion)) continue;
            return true;
        }
        return false;
    }

    public boolean accountingAvailable() {
        return this.accountingAvailable;
    }

    public String version() {
        return this.version;
    }
}

