/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.local;

import java.util.Map;
import nl.esciencecenter.xenon.InvalidCredentialException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.XenonPropertyDescription;
import nl.esciencecenter.xenon.adaptors.XenonProperties;
import nl.esciencecenter.xenon.adaptors.schedulers.JobQueueScheduler;
import nl.esciencecenter.xenon.adaptors.schedulers.SchedulerAdaptor;
import nl.esciencecenter.xenon.adaptors.schedulers.local.LocalInteractiveProcessFactory;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.credentials.DefaultCredential;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.schedulers.Scheduler;

public class LocalSchedulerAdaptor
extends SchedulerAdaptor {
    public static final String ADAPTOR_NAME = "local";
    public static final String PREFIX = "xenon.adaptors.schedulers.local.";
    public static final String ADAPTOR_DESCRIPTION = "The local jobs adaptor implements all functionality by emulating a local queue.";
    public static final String QUEUE = "xenon.adaptors.schedulers.local.queue.";
    public static final String MAX_HISTORY = "xenon.adaptors.schedulers.local.queue.historySize";
    public static final String POLLING_DELAY = "xenon.adaptors.schedulers.local.queue.pollingDelay";
    public static final String MULTIQ = "xenon.adaptors.schedulers.local.queue.multi.";
    public static final String MULTIQ_MAX_CONCURRENT = "xenon.adaptors.schedulers.local.queue.multi.maxConcurrentJobs";
    public static final String INFO = "xenon.adaptors.schedulers.local.info.";
    public static final String JOBS = "xenon.adaptors.schedulers.local.info.jobs.";
    public static final String SUBMITTED = "xenon.adaptors.schedulers.local.info.jobs.submitted";
    public static final String[] ADAPTOR_LOCATIONS = new String[]{"[/workdir]"};
    public static final XenonPropertyDescription[] VALID_PROPERTIES = new XenonPropertyDescription[]{new XenonPropertyDescription("xenon.adaptors.schedulers.local.queue.pollingDelay", XenonPropertyDescription.Type.LONG, "1000", "The polling delay for monitoring running jobs (in milliseconds)."), new XenonPropertyDescription("xenon.adaptors.schedulers.local.queue.multi.maxConcurrentJobs", XenonPropertyDescription.Type.INTEGER, "4", "The maximum number of concurrent jobs in the multiq.")};

    public LocalSchedulerAdaptor() {
        super(ADAPTOR_NAME, ADAPTOR_DESCRIPTION, ADAPTOR_LOCATIONS, VALID_PROPERTIES);
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public boolean supportsInteractive() {
        return true;
    }

    @Override
    public Scheduler createScheduler(String location, Credential credential, Map<String, String> properties) throws XenonException {
        XenonProperties xp = new XenonProperties(VALID_PROPERTIES, properties);
        if (credential != null && !(credential instanceof DefaultCredential)) {
            throw new InvalidCredentialException(ADAPTOR_NAME, "Local scheduler does not support this credential!");
        }
        FileSystem filesystem = FileSystem.create("file", location, credential, properties);
        int processors = Runtime.getRuntime().availableProcessors();
        int multiQThreads = xp.getIntegerProperty(MULTIQ_MAX_CONCURRENT, processors);
        long pollingDelay = xp.getLongProperty(POLLING_DELAY);
        return new JobQueueScheduler(this.getNewUniqueID(), ADAPTOR_NAME, location == null ? "" : location, new LocalInteractiveProcessFactory(), filesystem, filesystem.getWorkingDirectory(), multiQThreads, pollingDelay, 0L, xp);
    }
}

