/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.gridengine;

import java.util.Arrays;
import java.util.Map;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.ScriptingParser;

class QueueInfo {
    private final String name;
    private final int slots;
    private final String[] parallelEnvironments;

    QueueInfo(Map<String, String> info) throws XenonException {
        this.name = info.get("qname");
        if (this.name == null) {
            throw new XenonException("gridengine", "Cannot find name of queue in output");
        }
        String slotsValue = info.get("slots");
        if (slotsValue == null) {
            throw new XenonException("gridengine", "Cannot find slots for queue \"" + this.name + "\"");
        }
        try {
            this.slots = Integer.parseInt(slotsValue);
        }
        catch (NumberFormatException e) {
            throw new XenonException("gridengine", "Cannot parse slots for queue \"" + this.name + "\", got \"" + slotsValue + "\"", e);
        }
        String peValue = info.get("pe_list");
        if (peValue == null) {
            throw new XenonException("gridengine", "Cannot find parallel environments for queue \"" + this.name + "\"");
        }
        this.parallelEnvironments = ScriptingParser.WHITESPACE_REGEX.split(peValue);
    }

    QueueInfo(String name, int slots, String ... parallelEnvironments) {
        this.name = name;
        this.slots = slots;
        this.parallelEnvironments = parallelEnvironments;
    }

    public String getName() {
        return this.name;
    }

    public int getSlots() {
        return this.slots;
    }

    public String[] getParallelEnvironments() {
        return this.parallelEnvironments;
    }

    public String toString() {
        return "QueueInfo [name=" + this.name + ", slots=" + this.slots + ", parallelEnvironments=" + Arrays.toString(this.parallelEnvironments) + "]";
    }
}

