/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.gridengine;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.IncompatibleVersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GridEngineXmlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(GridEngineXmlParser.class);
    private static final String SGE62_SCHEMA_ATTRIBUTE = "xmlns:xsd";
    private static final String SGE62_SCHEMA_VALUE = "http://gridengine.sunsource.net/source/browse/*checkout*/gridengine/source/dist/util/resources/schemas/qstat/qstat.xsd?revision=1.11";
    private final DocumentBuilder documentBuilder;
    private final boolean ignoreVersion;

    GridEngineXmlParser(boolean ignoreVersion) throws XenonException {
        this.ignoreVersion = ignoreVersion;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XenonException("gridengine", "could not create parser for xml files", e);
        }
    }

    private void checkVersion(Document document) throws IncompatibleVersionException {
        Element documentElement = document.getDocumentElement();
        if (!documentElement.getAttribute(SGE62_SCHEMA_ATTRIBUTE).equals(SGE62_SCHEMA_VALUE)) {
            if (this.ignoreVersion) {
                LOGGER.warn("cannot determine version, version attribute found: \"" + documentElement.getAttribute(SGE62_SCHEMA_ATTRIBUTE) + "\". Ignoring as requested by " + "xenon.adaptors.schedulers.gridengine.ignore.version");
            } else {
                throw new IncompatibleVersionException("gridengine", "cannot determine version, version attribute found: \"" + documentElement.getAttribute(SGE62_SCHEMA_ATTRIBUTE) + "\". Use the " + "xenon.adaptors.schedulers.gridengine.ignore.version" + " property to ignore this error");
            }
        }
    }

    protected Document parseDocument(String data) throws XenonException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
            Document result = this.documentBuilder.parse(in);
            result.normalize();
            this.checkVersion(result);
            return result;
        }
        catch (SAXException e) {
            throw new XenonException("gridengine", "could not parse qstat xml file", e);
        }
        catch (IOException e) {
            throw new XenonException("gridengine", "could not read xml file", e);
        }
    }

    private Map<String, String> mapFromElement(Element root) {
        HashMap<String, String> result = new HashMap<String, String>();
        NodeList tagNodes = root.getChildNodes();
        for (int j = 0; j < tagNodes.getLength(); ++j) {
            NodeList children;
            String key;
            Node tagNode = tagNodes.item(j);
            if (tagNode.getNodeType() != 1 || (key = tagNode.getNodeName()) == null || key.length() <= 0 || (children = tagNode.getChildNodes()).getLength() <= 0) continue;
            String value = tagNode.getChildNodes().item(0).getNodeValue();
            result.put(key, value);
        }
        return result;
    }

    protected Map<String, Map<String, String>> parseQueueInfos(String input) throws XenonException {
        Document document = this.parseDocument(input);
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        LOGGER.debug("root node of xml file: " + document.getDocumentElement().getNodeName());
        NodeList clusterNodes = document.getElementsByTagName("cluster_queue_summary");
        for (int i = 0; i < clusterNodes.getLength(); ++i) {
            Node clusterNode = clusterNodes.item(i);
            if (clusterNode.getNodeType() != 1) continue;
            Map<String, String> queueInfo = this.mapFromElement((Element)clusterNode);
            String queueName = queueInfo.get("name");
            if (queueName == null || queueName.length() == 0) {
                throw new XenonException("gridengine", "found queue in queue list with no name");
            }
            result.put(queueName, queueInfo);
        }
        if (result.size() == 0) {
            throw new XenonException("gridengine", "server seems to have no queues");
        }
        return result;
    }

    protected Map<String, Map<String, String>> parseJobInfos(String data) throws XenonException {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        Document document = this.parseDocument(data);
        LOGGER.debug("root node of xml file: " + document.getDocumentElement().getNodeName());
        NodeList nodes = document.getElementsByTagName("job_list");
        for (int i = 0; i < nodes.getLength(); ++i) {
            String jobID;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            Map<String, String> jobInfo = this.mapFromElement(element);
            String state = element.getAttribute("state");
            if (state != null && state.length() > 0) {
                jobInfo.put("long_state", state);
            }
            if ((jobID = jobInfo.get("JB_job_number")) == null || jobID.length() == 0) {
                throw new XenonException("gridengine", "found job in queue with no job number");
            }
            result.put(jobID, jobInfo);
        }
        return result;
    }
}

