/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers;

import java.io.IOException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.BatchProcess;
import nl.esciencecenter.xenon.adaptors.schedulers.Deadline;
import nl.esciencecenter.xenon.adaptors.schedulers.InteractiveProcess;
import nl.esciencecenter.xenon.adaptors.schedulers.InteractiveProcessFactory;
import nl.esciencecenter.xenon.adaptors.schedulers.JobCanceledException;
import nl.esciencecenter.xenon.adaptors.schedulers.JobStatusImplementation;
import nl.esciencecenter.xenon.adaptors.schedulers.Process;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.filesystems.Path;
import nl.esciencecenter.xenon.schedulers.JobDescription;
import nl.esciencecenter.xenon.schedulers.JobStatus;
import nl.esciencecenter.xenon.schedulers.Streams;

public class JobExecutor
implements Runnable {
    private static final String PENDING_STATE = "PENDING";
    private static final String RUNNING_STATE = "RUNNING";
    private static final String DONE_STATE = "DONE";
    private static final String ERROR_STATE = "ERROR";
    private static final String KILLED_STATE = "KILLED";
    private static final long POLLING_DELAY = 1000L;
    private static final long MILLISECONDS_PER_MINUTE = 60000L;
    private final JobDescription description;
    private final String jobIdentifier;
    private final boolean interactive;
    private final InteractiveProcessFactory factory;
    private final long pollingDelay;
    private final long startupTimeout;
    private final String adaptorName;
    private final FileSystem filesystem;
    private final Path workingDirectory;
    private Streams streams;
    private Integer exitStatus;
    private boolean updateSignal = false;
    private boolean isRunning = false;
    private boolean killed = false;
    private boolean done = false;
    private boolean hasRun = false;
    private String state = "PENDING";
    private XenonException error;

    public JobExecutor(String adaptorName, FileSystem filesystem, Path workingDirectory, InteractiveProcessFactory factory, JobDescription description, String jobIdentifier, boolean interactive, long pollingDelay, long startupTimeout) {
        this.adaptorName = adaptorName;
        this.filesystem = filesystem;
        this.workingDirectory = workingDirectory;
        this.description = description;
        this.jobIdentifier = jobIdentifier;
        this.interactive = interactive;
        this.factory = factory;
        this.pollingDelay = pollingDelay;
        this.startupTimeout = startupTimeout;
    }

    public synchronized boolean hasRun() {
        return this.hasRun;
    }

    public synchronized boolean kill() {
        if (this.done) {
            return true;
        }
        this.killed = true;
        if (!this.isRunning) {
            this.updateState(KILLED_STATE, -1, new JobCanceledException(this.adaptorName, "Process cancelled by user."));
            return true;
        }
        return false;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public String getJobIdentifier() {
        return this.jobIdentifier;
    }

    public JobDescription getJobDescription() {
        return this.description;
    }

    public synchronized JobStatus getStatus() {
        if (!this.done && RUNNING_STATE.equals(this.state)) {
            this.triggerStatusUpdate();
            this.waitForStatusUpdate(this.pollingDelay);
        }
        return new JobStatusImplementation(this.jobIdentifier, this.state, this.exitStatus, this.error, RUNNING_STATE.equals(this.state), this.done, null);
    }

    public synchronized String getState() {
        return this.state;
    }

    public synchronized Exception getError() {
        return this.error;
    }

    private synchronized void updateState(String state, int exitStatus, XenonException e) {
        if (ERROR_STATE.equals(state) || KILLED_STATE.equals(state)) {
            this.error = e;
            this.done = true;
        } else if (DONE_STATE.equals(state)) {
            this.exitStatus = exitStatus;
            this.done = true;
        } else if (RUNNING_STATE.equals(state)) {
            this.hasRun = true;
        } else {
            throw new InternalError("Illegal state: " + state);
        }
        this.state = state;
        this.clearUpdateRequest();
    }

    private synchronized boolean getKilled() {
        this.isRunning = true;
        return this.killed;
    }

    private synchronized void setStreams(Streams streams) {
        this.streams = streams;
    }

    public synchronized Streams getStreams() throws XenonException {
        if (this.streams == null) {
            throw new XenonException(this.adaptorName, "Streams not available");
        }
        return this.streams;
    }

    public synchronized JobStatus waitUntilRunning(long timeout) {
        long deadline = Deadline.getDeadline(timeout);
        this.triggerStatusUpdate();
        long leftover = deadline - System.currentTimeMillis();
        while (leftover > 0L && PENDING_STATE.equals(this.state)) {
            try {
                this.wait(leftover);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            leftover = deadline - System.currentTimeMillis();
        }
        return this.getStatus();
    }

    public synchronized JobStatus waitUntilDone(long timeout) {
        long deadline = Deadline.getDeadline(timeout);
        this.triggerStatusUpdate();
        long leftover = deadline - System.currentTimeMillis();
        while (leftover > 0L && !this.done) {
            try {
                this.wait(leftover);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            leftover = deadline - System.currentTimeMillis();
        }
        return this.getStatus();
    }

    private synchronized void triggerStatusUpdate() {
        if (this.done) {
            return;
        }
        this.updateSignal = true;
        this.notifyAll();
    }

    private synchronized void waitForStatusUpdate(long maxDelay) {
        long left;
        if (this.done || !this.updateSignal) {
            return;
        }
        long deadline = Deadline.getDeadline(maxDelay);
        long l = left = maxDelay > 0L ? maxDelay : 1000L;
        while (!this.done && this.updateSignal && left > 0L) {
            try {
                this.wait(left);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            if (maxDelay <= 0L) continue;
            left = deadline - System.currentTimeMillis();
        }
    }

    private synchronized void clearUpdateRequest() {
        this.updateSignal = false;
        this.notifyAll();
    }

    private synchronized void sleep(long maxDelay) {
        if (this.done || this.updateSignal || maxDelay <= 0L) {
            return;
        }
        long deadline = Deadline.getDeadline(maxDelay);
        long left = deadline - System.currentTimeMillis();
        while (!this.done && !this.updateSignal && left > 0L) {
            try {
                this.wait(left);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            left = deadline - System.currentTimeMillis();
        }
    }

    @Override
    public void run() {
        Process process;
        if (this.getKilled()) {
            this.updateState(KILLED_STATE, -1, new JobCanceledException(this.adaptorName, "Process cancelled by user."));
            return;
        }
        long endTime = 0L;
        int maxTime = this.description.getMaxRuntime();
        if (maxTime > 0) {
            endTime = System.currentTimeMillis() + (long)maxTime * 60000L;
        }
        try {
            if (this.interactive) {
                InteractiveProcess p = this.factory.createInteractiveProcess(this.description, this.jobIdentifier, this.startupTimeout);
                this.setStreams(p.getStreams());
                process = p;
            } else {
                process = new BatchProcess(this.filesystem, this.workingDirectory, this.description, this.jobIdentifier, this.factory, this.startupTimeout);
            }
        }
        catch (XenonException e) {
            this.updateState(ERROR_STATE, -1, e);
            return;
        }
        catch (IOException e) {
            this.updateState(ERROR_STATE, -1, new XenonException(this.adaptorName, "Error starting job.", e));
            return;
        }
        this.updateState(RUNNING_STATE, -1, null);
        while (true) {
            if (process.isDone()) {
                this.updateState(DONE_STATE, process.getExitStatus(), null);
                return;
            }
            if (this.getKilled()) {
                process.destroy();
                this.updateState(KILLED_STATE, -1, new JobCanceledException(this.adaptorName, "Process cancelled by user."));
                return;
            }
            if (maxTime > 0 && System.currentTimeMillis() > endTime) {
                process.destroy();
                this.updateState(KILLED_STATE, -1, new JobCanceledException(this.adaptorName, "Process timed out."));
                return;
            }
            this.clearUpdateRequest();
            this.sleep(this.pollingDelay);
        }
    }
}

