/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.filesystems.webdav;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.impl.SardineException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nl.esciencecenter.xenon.UnsupportedOperationException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.XenonProperties;
import nl.esciencecenter.xenon.adaptors.filesystems.PathAttributesImplementation;
import nl.esciencecenter.xenon.adaptors.filesystems.webdav.WebdavFileAdaptor;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.filesystems.Path;
import nl.esciencecenter.xenon.filesystems.PathAttributes;
import nl.esciencecenter.xenon.filesystems.PosixFilePermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebdavFileSystem
extends FileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebdavFileAdaptor.class);
    private final Sardine client;
    private final String server;

    protected WebdavFileSystem(String uniqueID, String name, String location, String server, Path entryPath, int bufferSize, Sardine client, XenonProperties properties) {
        super(uniqueID, name, location, entryPath, bufferSize, properties);
        this.client = client;
        this.server = server;
    }

    private String getFilePath(Path path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute!");
        }
        return this.server + path.toString();
    }

    private String getDirectoryPath(Path path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute!");
        }
        return this.server + path.toString() + "/";
    }

    private PathAttributes getAttributes(Path path, DavResource p) {
        PathAttributesImplementation attributes = new PathAttributesImplementation();
        attributes.setPath(path);
        attributes.setDirectory(p.isDirectory());
        attributes.setRegular(!p.isDirectory());
        attributes.setCreationTime(p.getCreation().getTime());
        attributes.setLastModifiedTime(p.getModified().getTime());
        attributes.setLastAccessTime(attributes.getLastModifiedTime());
        attributes.setSize(p.getContentLength());
        attributes.setReadable(true);
        attributes.setWritable(false);
        return attributes;
    }

    protected List<PathAttributes> listDirectory(Path path) throws XenonException {
        List list = null;
        try {
            list = this.client.list(this.getDirectoryPath(path), 1);
        }
        catch (Exception e) {
            throw new XenonException("webdav", "Failed to list directory: " + path, e);
        }
        ArrayList<PathAttributes> result = new ArrayList<PathAttributes>(list.size());
        String dirPath = path.toString() + "/";
        for (DavResource d : list) {
            if (dirPath.equals(d.getPath())) continue;
            String filename = d.getName();
            result.add(this.getAttributes(path.resolve(filename), d));
        }
        return result;
    }

    @Override
    public boolean isOpen() throws XenonException {
        return true;
    }

    @Override
    public void rename(Path source, Path target) throws XenonException {
        LOGGER.debug("move source = {} to target = {}", (Object)source, (Object)target);
        Path absSource = this.toAbsolutePath(source);
        Path absTarget = this.toAbsolutePath(target);
        this.assertPathExists(absSource);
        if (this.areSamePaths(absSource, absTarget)) {
            return;
        }
        this.assertParentDirectoryExists(absTarget);
        this.assertPathNotExists(absTarget);
        PathAttributes a = this.getAttributes(absSource);
        try {
            if (a.isDirectory()) {
                this.client.move(this.getDirectoryPath(absSource), this.getDirectoryPath(absTarget), false);
            } else {
                this.client.move(this.getFilePath(absSource), this.getFilePath(absTarget), false);
            }
        }
        catch (SardineException e) {
            if (e.getStatusCode() == 301) {
                return;
            }
            throw new XenonException("webdav", "Failed to move from " + absSource + " to " + absTarget, e);
        }
        catch (Exception e1) {
            throw new XenonException("webdav", "Failed to move from " + absSource + " to " + absTarget, e1);
        }
    }

    @Override
    public void createDirectory(Path dir) throws XenonException {
        LOGGER.debug("createDirectory dir = {}", (Object)dir);
        Path absDir = this.toAbsolutePath(dir);
        this.assertPathNotExists(absDir);
        this.assertParentDirectoryExists(absDir);
        try {
            this.client.createDirectory(this.getDirectoryPath(absDir));
        }
        catch (Exception e) {
            throw new XenonException("webdav", "Failed to create directory: " + absDir, e);
        }
    }

    @Override
    public void createFile(Path file) throws XenonException {
        LOGGER.debug("createFile path = {}", (Object)file);
        Path absFile = this.toAbsolutePath(file);
        this.assertPathNotExists(absFile);
        this.assertParentDirectoryExists(absFile);
        try {
            this.client.put(this.getFilePath(absFile), new byte[0]);
        }
        catch (Exception e) {
            throw new XenonException("webdav", "Failed to create file: " + absFile, e);
        }
    }

    @Override
    public void createSymbolicLink(Path link, Path path) throws XenonException {
        throw new UnsupportedOperationException("webdav", "Operation not supported");
    }

    @Override
    protected void deleteFile(Path path) throws XenonException {
        try {
            this.client.delete(this.getFilePath(path));
        }
        catch (Exception e) {
            throw new XenonException("webdav", "Failed to delete file: " + path, e);
        }
    }

    @Override
    protected void deleteDirectory(Path path) throws XenonException {
        try {
            this.client.delete(this.getDirectoryPath(path));
        }
        catch (Exception e) {
            throw new XenonException("webdav", "Failed to delete directory: " + path, e);
        }
    }

    @Override
    public boolean exists(Path path) throws XenonException {
        Path absPath = this.toAbsolutePath(path);
        try {
            return this.client.exists(this.getDirectoryPath(absPath)) || this.client.exists(this.getFilePath(absPath));
        }
        catch (IOException e) {
            throw new XenonException("webdav", "Failed to check existence of directory: " + absPath);
        }
    }

    @Override
    public InputStream readFromFile(Path path) throws XenonException {
        Path absPath = this.toAbsolutePath(path);
        this.assertFileExists(absPath);
        try {
            return this.client.get(this.getFilePath(absPath));
        }
        catch (IOException e) {
            throw new XenonException("webdav", "Failed to access file: " + absPath);
        }
    }

    @Override
    public OutputStream writeToFile(Path file, long size) throws XenonException {
        Path absFile = this.toAbsolutePath(file);
        this.assertPathNotExists(absFile);
        this.assertParentDirectoryExists(absFile);
        try {
            PipedInputStream in = new PipedInputStream(4096);
            PipedOutputStream out = new PipedOutputStream(in);
            new StreamToFileWriter(this.getFilePath(absFile), in).start();
            return out;
        }
        catch (Exception e) {
            throw new XenonException("webdav", "Failed to open stream for writing", e);
        }
    }

    @Override
    public OutputStream appendToFile(Path file) throws XenonException {
        throw new XenonException("webdav", "Appending to file not supported");
    }

    @Override
    public OutputStream writeToFile(Path file) throws XenonException {
        return this.writeToFile(file, -1L);
    }

    @Override
    public PathAttributes getAttributes(Path path) throws XenonException {
        Path absPath = this.toAbsolutePath(path);
        this.assertPathExists(absPath);
        try {
            List result = this.client.list(this.getFilePath(absPath), 0);
            return this.getAttributes(absPath, (DavResource)result.get(0));
        }
        catch (Exception e) {
            throw new XenonException("webdav", "Failed to get attributes for file: " + absPath, e);
        }
    }

    @Override
    public Path readSymbolicLink(Path link) throws XenonException {
        throw new XenonException("webdav", "Operation not supported");
    }

    @Override
    public void setPosixFilePermissions(Path path, Set<PosixFilePermission> permissions) throws XenonException {
        throw new XenonException("webdav", "Operation not supported");
    }

    class StreamToFileWriter
    extends Thread {
        private final String url;
        private final InputStream in;

        StreamToFileWriter(String url, InputStream in) {
            this.url = url;
            this.in = in;
            this.setName("WebdavStreamToFileWriter");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                WebdavFileSystem.this.client.put(this.url, this.in);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

