/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.filesystems;

import java.util.HashSet;
import java.util.Set;
import nl.esciencecenter.xenon.filesystems.PosixFilePermission;

public class PosixFileUtils {
    public static final int READ_OWNER = 256;
    public static final int WRITE_OWNER = 128;
    public static final int EXEC_OWNER = 64;
    public static final int READ_GROUP = 32;
    public static final int WRITE_GROUP = 16;
    public static final int EXEC_GROUP = 8;
    public static final int READ_OTHERS = 4;
    public static final int WRITE_OTHERS = 2;
    public static final int EXEC_OTHERS = 1;

    public static Set<PosixFilePermission> bitsToPermissions(int bit) {
        HashSet<PosixFilePermission> result = new HashSet<PosixFilePermission>();
        if ((bit & 0x100) != 0) {
            result.add(PosixFilePermission.OWNER_READ);
        }
        if ((bit & 0x80) != 0) {
            result.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((bit & 0x40) != 0) {
            result.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((bit & 0x20) != 0) {
            result.add(PosixFilePermission.GROUP_READ);
        }
        if ((bit & 0x10) != 0) {
            result.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((bit & 8) != 0) {
            result.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((bit & 4) != 0) {
            result.add(PosixFilePermission.OTHERS_READ);
        }
        if ((bit & 2) != 0) {
            result.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((bit & 1) != 0) {
            result.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return result;
    }

    private PosixFileUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static int permissionsToBits(Set<PosixFilePermission> permissions) {
        int bits = 0;
        for (PosixFilePermission p : permissions) {
            switch (p) {
                case OWNER_READ: {
                    bits |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    bits |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    bits |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    bits |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    bits |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    bits |= 8;
                    break;
                }
                case OTHERS_READ: {
                    bits |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    bits |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    bits |= 1;
                    break;
                }
            }
        }
        return bits;
    }

    public static boolean isExecutable(int permissions) {
        return (permissions & 0x40) != 0;
    }

    public static boolean isReadable(int permissions) {
        return (permissions & 0x100) != 0;
    }

    public static boolean isWritable(int permissions) {
        return (permissions & 0x80) != 0;
    }
}

