/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.escape.Escaper;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.net.PercentEscaper;
import com.google.inject.ImplementedBy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.InvalidKeyException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.inject.Inject;
import javax.xml.ws.http.HTTPException;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Macs;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.http.utils.Queries;
import org.jclouds.io.Payload;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.s3.filters.AwsHostNameUtils;
import org.jclouds.util.Strings2;

public abstract class Aws4SignerBase {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    protected final DateFormat timestampFormat;
    protected final DateFormat dateFormat;
    private static final Escaper AWS_URL_PARAMETER_ESCAPER = new PercentEscaper("-_.~", false);
    private static final Escaper AWS_PATH_ESCAPER = new PercentEscaper("/-_.~", false);
    protected final String headerTag;
    protected final ServiceAndRegion serviceAndRegion;
    protected final SignatureWire signatureWire;
    protected final Supplier<Credentials> creds;
    protected final Supplier<Date> timestampProvider;
    protected final Crypto crypto;

    protected Aws4SignerBase(SignatureWire signatureWire, String headerTag, Supplier<Credentials> creds, Supplier<Date> timestampProvider, ServiceAndRegion serviceAndRegion, Crypto crypto) {
        this.signatureWire = signatureWire;
        this.headerTag = headerTag;
        this.creds = creds;
        this.timestampProvider = timestampProvider;
        this.serviceAndRegion = serviceAndRegion;
        this.crypto = crypto;
        this.timestampFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        this.timestampFormat.setTimeZone(GMT);
        this.dateFormat = new SimpleDateFormat("yyyyMMdd");
        this.dateFormat.setTimeZone(GMT);
    }

    protected static String hostHeaderFor(URI endpoint) {
        String scheme = endpoint.getScheme();
        String host = endpoint.getHost();
        int port = endpoint.getPort();
        if (port != -1 && ("http".equalsIgnoreCase(scheme) && port != 80 || "https".equalsIgnoreCase(scheme) && port != 443)) {
            host = host + ":" + port;
        }
        return host;
    }

    protected String getContentType(HttpRequest request) {
        Payload payload = request.getPayload();
        String contentType = request.getFirstHeaderOrNull("Content-Type");
        if (payload != null && payload.getContentMetadata() != null && payload.getContentMetadata().getContentType() != null) {
            contentType = payload.getContentMetadata().getContentType();
        }
        return contentType;
    }

    protected String getContentLength(HttpRequest request) {
        Payload payload = request.getPayload();
        String contentLength = request.getFirstHeaderOrNull("Content-Length");
        if (payload != null && payload.getContentMetadata() != null && payload.getContentMetadata().getContentType() != null) {
            Long length = payload.getContentMetadata().getContentLength();
            contentLength = length == null ? contentLength : String.valueOf(payload.getContentMetadata().getContentLength());
        }
        return contentLength;
    }

    protected void appendAmzHeaders(HttpRequest request, ImmutableMap.Builder<String, String> signedHeadersBuilder) {
        for (Map.Entry header : request.getHeaders().entries()) {
            String key = (String)header.getKey();
            if (!key.startsWith("x-" + this.headerTag + "-")) continue;
            signedHeadersBuilder.put((Object)key.toLowerCase(), header.getValue());
        }
    }

    protected byte[] signatureKey(String secretKey, String datestamp, String region, String service) {
        byte[] kSecret = ("AWS4" + secretKey).getBytes(Charsets.UTF_8);
        byte[] kDate = this.hmacSHA256(datestamp, kSecret);
        byte[] kRegion = this.hmacSHA256(region, kDate);
        byte[] kService = this.hmacSHA256(service, kRegion);
        byte[] kSigning = this.hmacSHA256("aws4_request", kService);
        return kSigning;
    }

    protected byte[] hmacSHA256(String toSign, byte[] key) {
        try {
            return (byte[])ByteStreams.readBytes((InputStream)Strings2.toInputStream((String)toSign), Aws4SignerBase.hmacSHA256(this.crypto, key));
        }
        catch (IOException e) {
            throw new HttpException("read sign error", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new HttpException("invalid key", (Throwable)e);
        }
    }

    public static ByteProcessor<byte[]> hmacSHA256(Crypto crypto, byte[] signatureKey) throws InvalidKeyException {
        return Macs.asByteProcessor((Mac)crypto.hmacSHA256(signatureKey));
    }

    public static byte[] hash(InputStream input) throws HTTPException {
        HashingInputStream his = new HashingInputStream(Hashing.sha256(), input);
        try {
            ByteStreams.copy((InputStream)his, (OutputStream)ByteStreams.nullOutputStream());
            return his.hash().asBytes();
        }
        catch (IOException e) {
            throw new HttpException("Unable to compute hash while signing request: " + e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] hash(byte[] bytes) throws HTTPException {
        try {
            return ByteSource.wrap((byte[])bytes).hash(Hashing.sha256()).asBytes();
        }
        catch (IOException e) {
            throw new HttpException("Unable to compute hash while signing request: " + e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] hash(String input) throws HTTPException {
        return Aws4SignerBase.hash(new ByteArrayInputStream(input.getBytes(Charsets.UTF_8)));
    }

    protected String getCanonicalizedQueryString(String queryString) {
        Multimap params = (Multimap)Queries.queryParser().apply((Object)queryString);
        TreeMap sorted = Maps.newTreeMap();
        if (params == null) {
            return "";
        }
        for (Map.Entry pair : params.entries()) {
            String key = (String)pair.getKey();
            String value = (String)pair.getValue();
            sorted.put(Aws4SignerBase.urlEncode(key), Aws4SignerBase.urlEncode(value));
        }
        return Joiner.on((String)"&").withKeyValueSeparator("=").join((Map)sorted);
    }

    public static String urlEncode(String value) {
        if (value == null) {
            return "";
        }
        return AWS_URL_PARAMETER_ESCAPER.escape(value);
    }

    public static String hex(byte[] bytes) {
        return BaseEncoding.base16().lowerCase().encode(bytes);
    }

    protected String createStringToSign(String method, URI endpoint, Map<String, String> signedHeaders, String timestamp, String credentialScope, String hashedPayload) {
        Map<String, String> lowerCaseHeaders = Aws4SignerBase.lowerCaseNaturalOrderKeys(signedHeaders);
        StringBuilder canonicalRequest = new StringBuilder();
        canonicalRequest.append(method).append("\n");
        canonicalRequest.append(AWS_PATH_ESCAPER.escape(endpoint.getPath())).append("\n");
        if (endpoint.getQuery() != null) {
            canonicalRequest.append(this.getCanonicalizedQueryString(endpoint.getQuery()));
        }
        canonicalRequest.append("\n");
        for (Map.Entry<String, String> entry : lowerCaseHeaders.entrySet()) {
            canonicalRequest.append(entry.getKey()).append(':').append(entry.getValue()).append('\n');
        }
        canonicalRequest.append("\n");
        canonicalRequest.append(Joiner.on((char)';').join(lowerCaseHeaders.keySet())).append('\n');
        canonicalRequest.append(hashedPayload);
        this.signatureWire.getWireLog().debug("<< " + canonicalRequest, new Object[0]);
        StringBuilder toSign = new StringBuilder();
        toSign.append("AWS4-HMAC-SHA256").append('\n');
        toSign.append(timestamp).append('\n');
        toSign.append(credentialScope).append('\n');
        toSign.append(Aws4SignerBase.hex(Aws4SignerBase.hash(canonicalRequest.toString())));
        return toSign.toString();
    }

    protected static Map<String, String> lowerCaseNaturalOrderKeys(Map<String, String> in) {
        Preconditions.checkNotNull(in, (Object)"input map");
        ImmutableSortedMap.Builder returnVal = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<String, String> entry : in.entrySet()) {
            returnVal.put((Object)entry.getKey().toLowerCase(Locale.US), (Object)entry.getValue());
        }
        return returnVal.build();
    }

    @ImplementedBy(value=AWSServiceAndRegion.class)
    public static interface ServiceAndRegion {
        public String service();

        public String region(String var1);

        public static final class AWSServiceAndRegion
        implements ServiceAndRegion {
            private final String service;

            @Inject
            AWSServiceAndRegion(ProviderMetadata provider) {
                this(provider.getEndpoint());
            }

            AWSServiceAndRegion(String endpoint) {
                this.service = AwsHostNameUtils.parseServiceName(URI.create((String)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint")));
            }

            @Override
            public String service() {
                return this.service;
            }

            @Override
            public String region(String host) {
                return AwsHostNameUtils.parseRegionName(host, this.service());
            }
        }
    }
}

