/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.smartsockets;

import ibis.io.BufferedArrayInputStream;
import ibis.io.BufferedArrayOutputStream;
import ibis.ipl.AlreadyConnectedException;
import ibis.ipl.CapabilitySet;
import ibis.ipl.ConnectionRefusedException;
import ibis.ipl.ConnectionTimedOutException;
import ibis.ipl.Credentials;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisCreationFailedException;
import ibis.ipl.IbisStarter;
import ibis.ipl.MessageUpcall;
import ibis.ipl.PortMismatchException;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.ReceivePortIdentifier;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.SendPort;
import ibis.ipl.SendPortDisconnectUpcall;
import ibis.ipl.impl.Ibis;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.impl.ReceivePort;
import ibis.ipl.impl.SendPortIdentifier;
import ibis.ipl.impl.smartsockets.SmartSocketsProtocol;
import ibis.ipl.impl.smartsockets.SmartSocketsReceivePort;
import ibis.ipl.impl.smartsockets.SmartSocketsSendPort;
import ibis.ipl.impl.smartsockets.SmartSocketsUltraLightReceivePort;
import ibis.ipl.impl.smartsockets.SmartSocketsUltraLightSendPort;
import ibis.ipl.support.Client;
import ibis.smartsockets.hub.servicelink.ServiceLink;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.util.ThreadPool;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmartSocketsIbis
extends Ibis
implements Runnable,
SmartSocketsProtocol {
    static final Logger logger = LoggerFactory.getLogger((String)"ibis.ipl.impl.smartsockets.SmartSocketsIbis");
    private VirtualSocketFactory factory;
    private VirtualServerSocket systemServer;
    private VirtualSocketAddress myAddress;
    private boolean quiting = false;
    private HashMap<ibis.ipl.IbisIdentifier, VirtualSocketAddress> addresses = new HashMap();
    private final HashMap<String, Object> lightConnection = new HashMap();
    private final HashMap<String, Object> directConnection = new HashMap();

    public SmartSocketsIbis(RegistryEventHandler registryEventHandler, IbisCapabilities capabilities, Credentials credentials, byte[] applicationTag, PortType[] types, Properties userProperties, IbisStarter starter) throws IbisCreationFailedException {
        super(registryEventHandler, capabilities, credentials, applicationTag, types, userProperties, starter);
        this.lightConnection.put("connect.module.allow", "ConnectModule(HubRouted)");
        this.directConnection.put("connect.module.allow", "ConnectModule(Direct)");
        this.properties.checkProperties("ibis.ipl.impl.smartsockets.", new String[]{"ibis.ipl.impl.smartsockets"}, null, true);
        try {
            ServiceLink sl = this.factory.getServiceLink();
            if (sl != null) {
                String colorString = "";
                if (this.properties.getProperty("ibis.location.color") != null) {
                    colorString = "^" + this.properties.getProperty("ibis.location.color");
                }
                sl.registerProperty("smartsockets.viz", "I^" + this.ident.name() + "^" + this.ident.name() + "," + this.ident.location().toString() + colorString);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        ThreadPool.createNew((Runnable)this, (String)"SmartSocketsIbis Accept Thread");
    }

    protected byte[] getData() throws IOException {
        String clientID = this.properties.getProperty("ibis.local.id");
        Client client = Client.getOrCreateClient((String)clientID, (Properties)this.properties, (int)0);
        this.factory = client.getFactory();
        this.systemServer = this.factory.createServerSocket(0, 50, true, null);
        this.myAddress = this.systemServer.getLocalSocketAddress();
        if (logger.isInfoEnabled()) {
            logger.info("--> SmartSocketIbis: address = " + this.myAddress);
        }
        return this.myAddress.toBytes();
    }

    ServiceLink getServiceLink() {
        return this.factory.getServiceLink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VirtualSocket connect(SmartSocketsSendPort sp, ibis.ipl.impl.ReceivePortIdentifier rip, int timeout, boolean fillTimeout) throws IOException {
        VirtualSocketAddress idAddr;
        IbisIdentifier id = (IbisIdentifier)rip.ibisIdentifier();
        String name = rip.name();
        HashMap<ibis.ipl.IbisIdentifier, VirtualSocketAddress> hashMap = this.addresses;
        synchronized (hashMap) {
            idAddr = this.addresses.get(id);
            if (idAddr == null) {
                idAddr = VirtualSocketAddress.fromBytes((byte[])id.getImplementationData(), (int)0);
                this.addresses.put((ibis.ipl.IbisIdentifier)id, idAddr);
            }
        }
        long startTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("--> Creating socket for connection to " + name + " at " + idAddr);
        }
        PortType sendPortType = sp.getPortType();
        while (true) {
            FilterOutputStream out = null;
            VirtualSocket s = null;
            int result = -1;
            try {
                HashMap<String, Object> h = null;
                if (sp.getPortType().hasCapability("connection.light")) {
                    h = this.lightConnection;
                } else if (sp.getPortType().hasCapability("connection.direct")) {
                    h = this.directConnection;
                }
                s = this.factory.createClientSocket(idAddr, timeout, fillTimeout, h);
                s.setTcpNoDelay(true);
                out = new DataOutputStream((OutputStream)new BufferedArrayOutputStream(s.getOutputStream()));
                ((DataOutputStream)out).writeUTF(name);
                sp.getIdent().writeTo((DataOutput)((Object)out));
                sendPortType.writeTo((DataOutput)((Object)out));
                ((DataOutputStream)out).flush();
                result = s.getInputStream().read();
                switch (result) {
                    case 0: {
                        VirtualSocket virtualSocket = s;
                        return virtualSocket;
                    }
                    case 3: {
                        throw new AlreadyConnectedException("Already connected", (ReceivePortIdentifier)rip);
                    }
                    case 4: {
                        DataInputStream in = new DataInputStream(s.getInputStream());
                        PortType rtp = new PortType((DataInput)in);
                        CapabilitySet s1 = rtp.unmatchedCapabilities((CapabilitySet)sendPortType);
                        CapabilitySet s2 = sendPortType.unmatchedCapabilities((CapabilitySet)rtp);
                        String message = "";
                        if (s1.size() != 0) {
                            message = message + "\nUnmatched receiveport capabilities: " + s1.toString() + ".";
                        }
                        if (s2.size() != 0) {
                            message = message + "\nUnmatched sendport capabilities: " + s2.toString() + ".";
                        }
                        throw new PortMismatchException("Cannot connect ports of different port types." + message, (ReceivePortIdentifier)rip);
                    }
                    case 1: {
                        throw new ConnectionRefusedException("Receiver denied connection", (ReceivePortIdentifier)rip);
                    }
                    case 6: {
                        throw new ConnectionRefusedException("Receiver already has a connection and neither ManyToOne not ManyToMany is set", (ReceivePortIdentifier)rip);
                    }
                    case 2: 
                    case 5: {
                        if (timeout > 0 && System.currentTimeMillis() > startTime + (long)timeout) {
                            throw new ConnectionTimedOutException("Could not connect", (ReceivePortIdentifier)rip);
                        }
                        break;
                    }
                    case -1: {
                        throw new IOException("Encountered EOF in SmartSocketsIbis.connect");
                    }
                    default: {
                        throw new IOException("Illegal opcode in SmartSocketsIbis.connect");
                    }
                }
            }
            catch (SocketTimeoutException e) {
                throw new ConnectionTimedOutException("Could not connect", (ReceivePortIdentifier)rip);
            }
            finally {
                if (result != 0) {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Throwable e) {}
                    try {
                        s.close();
                    }
                    catch (Throwable e) {}
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
            }
        }
    }

    protected void quit() {
        try {
            this.quiting = true;
            this.factory.createClientSocket(this.myAddress, 0, false, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnectionRequest(VirtualSocket s) throws IOException {
        byte result;
        if (logger.isDebugEnabled()) {
            logger.debug("--> SmartSocketsIbis got connection request from " + s);
        }
        BufferedArrayInputStream bais = new BufferedArrayInputStream(s.getInputStream());
        DataInputStream in = new DataInputStream((InputStream)bais);
        OutputStream out = s.getOutputStream();
        String name = in.readUTF();
        SendPortIdentifier send = new SendPortIdentifier((DataInput)in);
        PortType sp = new PortType((DataInput)in);
        SmartSocketsReceivePort rp = (SmartSocketsReceivePort)this.findReceivePort(name);
        if (rp == null) {
            int result2 = 5;
            out.write(result2);
            out.close();
            in.close();
            s.close();
            return;
        }
        SmartSocketsReceivePort smartSocketsReceivePort = rp;
        synchronized (smartSocketsReceivePort) {
            result = rp.connectionAllowed(send, sp);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("--> S RP = " + name + ": " + ReceivePort.getString((int)result));
        }
        out.write(result);
        if (result == 4) {
            DataOutputStream dout = new DataOutputStream(out);
            rp.getPortType().writeTo((DataOutput)dout);
            dout.flush();
        }
        out.flush();
        if (result == 0) {
            rp.connect(send, s, bais);
            if (logger.isDebugEnabled()) {
                logger.debug("--> S connect done ");
            }
        } else {
            out.close();
            in.close();
            s.close();
        }
    }

    @Override
    public void run() {
        boolean stop = false;
        while (!stop) {
            VirtualSocket s = null;
            if (logger.isDebugEnabled()) {
                logger.debug("--> SmartSocketsIbis doing new accept()");
            }
            try {
                s = this.systemServer.accept();
                s.setTcpNoDelay(true);
            }
            catch (Throwable e) {
                logger.error("SmartSocketsIbis:run: got fatal exception in accept! ", e);
                this.cleanup();
                throw new Error("Fatal: SmartSocketsIbis could not do an accept", e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("--> SmartSocketsIbis through new accept()");
            }
            try {
                if (this.quiting) {
                    s.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug("--> it is a quit: RETURN");
                    }
                    this.cleanup();
                    return;
                }
                stop = true;
                try {
                    Thread.currentThread().setName("Connection Handler");
                }
                catch (Exception e) {
                    // empty catch block
                }
                ThreadPool.createNew((Runnable)this, (String)"SmartSocketsIbis Accept Thread");
                this.handleConnectionRequest(s);
            }
            catch (Throwable e) {
                try {
                    s.close();
                }
                catch (Throwable e2) {
                    // empty catch block
                }
                logger.error("EEK: SmartSocketsIbis:run: got exception (closing this socket only: ", e);
            }
        }
    }

    private void cleanup() {
        try {
            this.systemServer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected SendPort doCreateSendPort(PortType tp, String nm, SendPortDisconnectUpcall cU, Properties props) throws IOException {
        if (tp.hasCapability("connection.ultralight")) {
            return new SmartSocketsUltraLightSendPort(this, tp, nm, props);
        }
        if (tp.hasCapability("connection.light")) {
            if (props == null) {
                props = new Properties();
            }
            props.put("connect.module.type.skip", "direct");
        } else if (tp.hasCapability("connection.direct")) {
            if (props == null) {
                props = new Properties();
            }
            props.put("connect.module.skip", "ConnectModule(HubRouted)");
        }
        return new SmartSocketsSendPort(this, tp, nm, cU, props);
    }

    protected ibis.ipl.ReceivePort doCreateReceivePort(PortType tp, String nm, MessageUpcall u, ReceivePortConnectUpcall cU, Properties props) throws IOException {
        if (tp.hasCapability("connection.ultralight")) {
            return new SmartSocketsUltraLightReceivePort(this, tp, nm, u, props);
        }
        if (tp.hasCapability("connection.light")) {
            if (props == null) {
                props = new Properties();
            }
            props.put("connect.module.type.skip", "direct");
        } else if (tp.hasCapability("connection.direct")) {
            if (props == null) {
                props = new Properties();
            }
            props.put("connect.module.skip", "ConnectModule(HubRouted)");
        }
        return new SmartSocketsReceivePort(this, tp, nm, u, cU, props);
    }
}

