/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.multi;

import ibis.ipl.Ibis;
import ibis.ipl.IbisConfigurationException;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.Registry;
import ibis.ipl.impl.multi.IbisIdentifierWrapper;
import ibis.ipl.impl.multi.ManageableMapper;
import ibis.ipl.impl.multi.MultiIbis;
import ibis.ipl.impl.multi.MultiIbisIdentifier;
import ibis.util.ThreadPool;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiRegistry
implements Registry {
    private static final Logger logger = LoggerFactory.getLogger(MultiRegistry.class);
    private final MultiIbis ibis;
    private final ManageableMapper ManageableMapper;
    private final HashMap<String, Registry> subRegistries;
    final Map<MultiIbisIdentifier, MultiIbisIdentifier> joined = Collections.synchronizedMap(new HashMap());
    final Map<MultiIbisIdentifier, MultiIbisIdentifier> left = Collections.synchronizedMap(new HashMap());
    final Map<MultiIbisIdentifier, MultiIbisIdentifier> died = Collections.synchronizedMap(new HashMap());
    final Map<String, MultiIbisIdentifier> elected = Collections.synchronizedMap(new HashMap());

    public MultiRegistry(MultiIbis multiIbis) {
        this.ibis = multiIbis;
        this.subRegistries = new HashMap();
        for (String ibisName : this.ibis.subIbisMap.keySet()) {
            Ibis subIbis = this.ibis.subIbisMap.get(ibisName);
            if (logger.isDebugEnabled()) {
                logger.debug("Registry for: " + ibisName + " : " + subIbis.registry());
            }
            this.subRegistries.put(ibisName, subIbis.registry());
        }
        this.ManageableMapper = new ManageableMapper(this.subRegistries);
    }

    public void assumeDead(IbisIdentifier ibisIdentifier) throws IOException {
        for (String ibisName : this.subRegistries.keySet()) {
            Registry subRegistry = this.subRegistries.get(ibisName);
            subRegistry.assumeDead(((MultiIbisIdentifier)ibisIdentifier).subIdForIbis(ibisName));
        }
    }

    public IbisIdentifier[] diedIbises() {
        HashMap<MultiIbisIdentifier, String> theDead = new HashMap<MultiIbisIdentifier, String>();
        for (String ibisName : this.subRegistries.keySet()) {
            Registry subRegistry = this.subRegistries.get(ibisName);
            IbisIdentifier[] ids = subRegistry.diedIbises();
            for (int i = 0; i < ids.length; ++i) {
                try {
                    theDead.put(this.ibis.mapIdentifier(ids[i], ibisName), ibisName);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return theDead.keySet().toArray(new IbisIdentifier[theDead.size()]);
    }

    public void disableEvents() {
        for (Registry subRegistry : this.subRegistries.values()) {
            subRegistry.disableEvents();
        }
    }

    public IbisIdentifier elect(String electionName) throws IOException {
        return this.elect(electionName, 0L);
    }

    public IbisIdentifier elect(String electionName, long timeoutMillis) throws IOException {
        if (this.subRegistries.size() > 0) {
            ArrayList<IbisIdentifierWrapper> elected;
            ArrayList<IbisIdentifierWrapper> arrayList = elected = new ArrayList<IbisIdentifierWrapper>();
            synchronized (arrayList) {
                for (String ibisName : this.subRegistries.keySet()) {
                    Registry subRegistry = this.subRegistries.get(ibisName);
                    ThreadPool.createNew((Runnable)new ElectionRunner(ibisName, subRegistry, elected, electionName, timeoutMillis), (String)("Election: " + electionName));
                }
                while (elected.size() < this.subRegistries.size()) {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Waiting for election: " + electionName + " count: " + elected.size() + " of: " + this.subRegistries.size() + " for: " + timeoutMillis);
                        }
                        elected.wait(timeoutMillis);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Woke up election: " + electionName + " count:" + elected.size() + " of: " + this.subRegistries.size());
                    }
                    catch (InterruptedException e) {}
                }
                if (!elected.isEmpty()) {
                    Collections.sort(elected);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Elected: " + elected.get(0));
                    }
                    return this.ibis.mapIdentifier(((IbisIdentifierWrapper)elected.get((int)0)).id, ((IbisIdentifierWrapper)elected.get((int)0)).ibisName);
                }
                throw new Error("No election results!");
            }
        }
        throw new Error("No Subregistries to support elections.");
    }

    public void enableEvents() {
        for (Registry subRegistry : this.subRegistries.values()) {
            subRegistry.enableEvents();
        }
    }

    public IbisIdentifier getElectionResult(String electionName) throws IOException {
        return this.getElectionResult(electionName, 0L);
    }

    public IbisIdentifier getElectionResult(String electionName, long timeoutMillis) throws IOException {
        IbisIdentifier results = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Getting Election Results for: " + electionName + " timeout: " + timeoutMillis);
        }
        timeoutMillis /= (long)this.subRegistries.size();
        ArrayList<MultiIbisIdentifier> elected = new ArrayList<MultiIbisIdentifier>();
        for (String ibisName : this.subRegistries.keySet()) {
            Registry subRegistry = this.subRegistries.get(ibisName);
            IbisIdentifier winner = subRegistry.getElectionResult(electionName, timeoutMillis);
            if (winner == null) continue;
            elected.add(this.ibis.mapIdentifier(winner, ibisName));
        }
        if (!elected.isEmpty()) {
            Collections.sort(elected);
            results = (IbisIdentifier)elected.get(0);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ElectionResult : " + electionName + " : " + results);
        }
        return results;
    }

    public int getPoolSize() {
        int poolSize = 0;
        for (Registry subRegistry : this.subRegistries.values()) {
            poolSize += subRegistry.getPoolSize();
        }
        return poolSize;
    }

    public String getPoolName() {
        return this.ibis.identifier().poolName();
    }

    public long getSequenceNumber(String name) throws IOException {
        throw new IOException("Sequences not supported!");
    }

    public IbisIdentifier[] joinedIbises() {
        HashMap<MultiIbisIdentifier, String> theJoined = new HashMap<MultiIbisIdentifier, String>();
        for (String ibisName : this.subRegistries.keySet()) {
            Registry subRegistry = this.subRegistries.get(ibisName);
            IbisIdentifier[] ids = subRegistry.joinedIbises();
            for (int i = 0; i < ids.length; ++i) {
                try {
                    theJoined.put(this.ibis.mapIdentifier(ids[i], ibisName), ibisName);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return theJoined.keySet().toArray(new IbisIdentifier[theJoined.size()]);
    }

    public IbisIdentifier[] leftIbises() {
        HashMap<MultiIbisIdentifier, String> theLeft = new HashMap<MultiIbisIdentifier, String>();
        for (String ibisName : this.subRegistries.keySet()) {
            Registry subRegistry = this.subRegistries.get(ibisName);
            IbisIdentifier[] ids = subRegistry.leftIbises();
            for (int i = 0; i < ids.length; ++i) {
                try {
                    theLeft.put(this.ibis.mapIdentifier(ids[i], ibisName), ibisName);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return theLeft.keySet().toArray(new IbisIdentifier[theLeft.size()]);
    }

    public void maybeDead(IbisIdentifier ibisIdentifier) throws IOException {
        for (String ibisName : this.subRegistries.keySet()) {
            Registry subRegistry = this.subRegistries.get(ibisName);
            subRegistry.maybeDead((IbisIdentifier)this.ibis.mapIdentifier(ibisIdentifier, ibisName));
        }
    }

    public String[] receivedSignals() {
        HashMap<String, String> theSignals = new HashMap<String, String>();
        for (Registry subRegistry : this.subRegistries.values()) {
            String[] signals = subRegistry.receivedSignals();
            for (int i = 0; i < signals.length; ++i) {
                theSignals.put(signals[i], signals[i]);
            }
        }
        return theSignals.keySet().toArray(new String[theSignals.size()]);
    }

    public void signal(String signal, IbisIdentifier ... ibisIdentifiers) throws IOException {
        IbisIdentifier[] ids = new IbisIdentifier[ibisIdentifiers.length];
        for (String ibisName : this.subRegistries.keySet()) {
            Registry subRegistry = this.subRegistries.get(ibisName);
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = ((MultiIbisIdentifier)ibisIdentifiers[i]).subIdForIbis(ibisName);
            }
            subRegistry.signal(signal, ids);
        }
    }

    public boolean isClosed() {
        for (Registry subRegistry : this.subRegistries.values()) {
            if (subRegistry.isClosed()) continue;
            return false;
        }
        return true;
    }

    public void waitUntilPoolClosed() {
        for (Registry subRegistry : this.subRegistries.values()) {
            subRegistry.waitUntilPoolClosed();
        }
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        return this.ManageableMapper.getManagementProperty(key);
    }

    public Map<String, String> managementProperties() {
        return this.ManageableMapper.managementProperties();
    }

    public void printManagementProperties(PrintStream stream) {
        this.ManageableMapper.printManagementProperties(stream);
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        this.ManageableMapper.setManagementProperties(properties);
    }

    public void setManagementProperty(String key, String value) throws NoSuchPropertyException {
        this.ManageableMapper.setManagementProperty(key, value);
    }

    public boolean hasTerminated() {
        throw new IbisConfigurationException("termination not supported by MultiRegistry");
    }

    public void terminate() throws IOException {
        throw new IbisConfigurationException("termination not supported by MultiRegistry");
    }

    public IbisIdentifier waitUntilTerminated() {
        throw new IbisConfigurationException("termination not supported by MultiRegistry");
    }

    private final class ElectionRunner
    implements Runnable {
        private final Registry subRegistry;
        private final String electionName;
        private final long timeoutMillis;
        private final List<IbisIdentifierWrapper> elected;
        private final String ibisName;

        public ElectionRunner(String ibisName, Registry subRegistry, List<IbisIdentifierWrapper> elected, String electionName, long timeoutMillis) {
            this.subRegistry = subRegistry;
            this.electionName = electionName;
            this.timeoutMillis = timeoutMillis;
            this.elected = elected;
            this.ibisName = ibisName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IbisIdentifier winner = null;
            try {
                winner = this.subRegistry.elect(this.electionName, this.timeoutMillis);
                if (logger.isDebugEnabled()) {
                    logger.debug("SubRegistry: " + this.subRegistry + " elected: " + winner);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            List<IbisIdentifierWrapper> list = this.elected;
            synchronized (list) {
                if (winner != null) {
                    this.elected.add(new IbisIdentifierWrapper(this.ibisName, winner));
                }
                this.elected.notify();
            }
        }
    }
}

