/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.multi;

import ibis.ipl.Credentials;
import ibis.ipl.Ibis;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisCreationFailedException;
import ibis.ipl.IbisFactory;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.MessageUpcall;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePort;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.ReceivePortIdentifier;
import ibis.ipl.Registry;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.SendPort;
import ibis.ipl.SendPortDisconnectUpcall;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.impl.multi.Location;
import ibis.ipl.impl.multi.ManageableMapper;
import ibis.ipl.impl.multi.MultiIbisIdentifier;
import ibis.ipl.impl.multi.MultiIbisStarter;
import ibis.ipl.impl.multi.MultiNameResolver;
import ibis.ipl.impl.multi.MultiReceivePort;
import ibis.ipl.impl.multi.MultiReceivePortIdentifier;
import ibis.ipl.impl.multi.MultiRegistry;
import ibis.ipl.impl.multi.MultiRegistryEventHandler;
import ibis.ipl.impl.multi.MultiSendPort;
import ibis.ipl.impl.multi.MultiSendPortIdentifier;
import ibis.util.TypedProperties;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MultiIbis
implements Ibis {
    private static final Logger logger = LoggerFactory.getLogger(MultiIbis.class);
    final MultiIbisIdentifier id;
    public static final PortType resolvePortType = new PortType(new String[]{"communication.reliable", "connection.manytoone", "receive.explicit", "serialization.object"});
    final HashMap<String, Ibis> subIbisMap = new HashMap();
    private final HashMap<IbisIdentifier, MultiIbisIdentifier> idMap = new HashMap();
    private final ArrayList<MultiSendPort> sendPorts = new ArrayList();
    private final ArrayList<MultiReceivePort> receivePorts = new ArrayList();
    private final TypedProperties properties;
    private final MultiRegistry registry;
    private final ManageableMapper ManageableMapper;
    final HashMap<ReceivePort, MultiReceivePort> receivePortMap = new HashMap();
    final Map<SendPort, MultiSendPort> sendPortMap = Collections.synchronizedMap(new HashMap());
    final HashMap<String, MultiNameResolver> resolverMap = new HashMap();
    final HashMap<String, MultiRegistryEventHandler> registryHandlerMap = new HashMap();
    private final HashMap<SendPortIdentifier, MultiSendPortIdentifier> sendPortIdMap = new HashMap();
    private final HashMap<ReceivePortIdentifier, MultiReceivePortIdentifier> receivePortIdMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiIbis(IbisFactory factory, RegistryEventHandler registryEventHandler, Properties userProperties, IbisCapabilities capabilities, Credentials credentials, byte[] applicationTag, PortType[] portTypes, String specifiedSubImplementation, MultiIbisStarter multiIbisStarter) {
        String[] implementations;
        if (logger.isDebugEnabled()) {
            logger.debug("Constructing MultiIbis!");
        }
        HashMap<String, IbisIdentifier> subIdMap = new HashMap<String, IbisIdentifier>();
        if (logger.isDebugEnabled()) {
            MDC.put((String)"UID", (String)String.valueOf(new Random().nextInt()));
        }
        if (!(userProperties instanceof TypedProperties)) {
            this.properties = new TypedProperties();
            this.properties.addProperties(userProperties);
        } else {
            this.properties = (TypedProperties)userProperties;
        }
        PortType[] requiredPortTypes = new PortType[portTypes.length + 1];
        System.arraycopy(portTypes, 0, requiredPortTypes, 0, portTypes.length);
        requiredPortTypes[portTypes.length] = resolvePortType;
        for (String implementation : implementations = specifiedSubImplementation.split(":")) {
            try {
                String poolName = userProperties.getProperty("ibis.pool.name");
                Properties subProperties = new Properties(userProperties);
                subProperties.setProperty("ibis.pool.name", poolName + ":" + implementation);
                MultiRegistryEventHandler handler = null;
                if (registryEventHandler != null) {
                    handler = new MultiRegistryEventHandler(this, registryEventHandler);
                }
                Ibis ibis = factory.createIbis((RegistryEventHandler)handler, capabilities, subProperties, credentials, applicationTag, requiredPortTypes, implementation);
                if (handler != null) {
                    handler.setName(implementation);
                    this.registryHandlerMap.put(implementation, handler);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Started ibis: " + implementation);
                }
                this.subIbisMap.put(implementation, ibis);
                subIdMap.put(implementation, ibis.identifier());
                try {
                    new MultiNameResolver(this, implementation);
                }
                catch (IOException e) {
                    throw new IbisCreationFailedException("Unable to create resolver.", (Throwable)e);
                }
            }
            catch (Throwable t) {
                logger.warn("Could not start child ibis", t);
            }
        }
        if (this.subIbisMap.size() == 0) {
            throw new RuntimeException("Unable to create any children!");
        }
        String poolName = userProperties.getProperty("ibis.pool.name");
        Location location = Location.defaultLocation(userProperties);
        this.id = new MultiIbisIdentifier(UUID.randomUUID().toString(), subIdMap, null, location, poolName, applicationTag);
        for (String ibisName : subIdMap.keySet()) {
            IbisIdentifier subId = subIdMap.get(ibisName);
            this.idMap.put(subId, this.id);
        }
        for (String ibisName : this.resolverMap.keySet()) {
            MultiNameResolver resolver;
            MultiNameResolver multiNameResolver = resolver = this.resolverMap.get(ibisName);
            synchronized (multiNameResolver) {
                resolver.notifyAll();
            }
        }
        this.registry = new MultiRegistry(this);
        for (String ibisName : this.registryHandlerMap.keySet()) {
            MultiRegistryEventHandler handler = this.registryHandlerMap.get(ibisName);
            handler.setRegistry(this.registry);
        }
        this.ManageableMapper = new ManageableMapper(this.subIbisMap);
        if (logger.isInfoEnabled()) {
            logger.info("MultiIbis Started with ID: " + this.id);
        }
    }

    public synchronized void end() throws IOException {
        for (Ibis ibis : this.subIbisMap.values()) {
            ibis.end();
        }
        for (MultiReceivePort multiReceivePort : this.receivePortMap.values()) {
            try {
                multiReceivePort.close(100L);
            }
            catch (IOException iOException) {}
        }
        for (MultiSendPort multiSendPort : this.sendPortMap.values()) {
            multiSendPort.quit(multiSendPort);
        }
        MultiNameResolver.quit();
    }

    public synchronized Registry registry() {
        return this.registry;
    }

    public synchronized void poll() throws IOException {
        for (Ibis ibis : this.subIbisMap.values()) {
            ibis.poll();
        }
    }

    public synchronized IbisIdentifier identifier() {
        return this.id;
    }

    public synchronized String getVersion() {
        StringBuffer buffer = new StringBuffer("MultiIbis on top of");
        for (Ibis ibis : this.subIbisMap.values()) {
            buffer.append(' ');
            buffer.append(ibis.getVersion());
        }
        return buffer.toString();
    }

    public synchronized Properties properties() {
        return this.properties;
    }

    public SendPort createSendPort(PortType portType) throws IOException {
        return this.createSendPort(portType, null, null, null);
    }

    public SendPort createSendPort(PortType portType, String name) throws IOException {
        return this.createSendPort(portType, name, null, null);
    }

    public synchronized SendPort createSendPort(PortType portType, String name, SendPortDisconnectUpcall cU, Properties props) throws IOException {
        MultiSendPort port = new MultiSendPort(portType, this, name, cU, props);
        this.sendPorts.add(port);
        return port;
    }

    public synchronized void closeSendPort(MultiSendPort port) {
        this.sendPorts.remove(port);
    }

    public synchronized void closeReceivePort(MultiReceivePort port) {
        this.receivePorts.remove(port);
    }

    public ReceivePort createReceivePort(PortType portType, String name) throws IOException {
        return this.createReceivePort(portType, name, null, null, null);
    }

    public ReceivePort createReceivePort(PortType portType, String name, MessageUpcall u) throws IOException {
        return this.createReceivePort(portType, name, u, null, null);
    }

    public ReceivePort createReceivePort(PortType portType, String name, ReceivePortConnectUpcall cU) throws IOException {
        return this.createReceivePort(portType, name, null, cU, null);
    }

    public synchronized ReceivePort createReceivePort(PortType portType, String name, MessageUpcall u, ReceivePortConnectUpcall cU, Properties props) throws IOException {
        MultiReceivePort port = new MultiReceivePort(portType, this, name, u, cU, props);
        this.receivePorts.add(port);
        return port;
    }

    public MultiIbisIdentifier mapIdentifier(IbisIdentifier ibisId, String ibisName) throws IOException {
        MultiIbisIdentifier id = this.idMap.get(ibisId);
        while (id == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to resolve: " + ibisId);
            }
            MultiNameResolver resolver = this.resolverMap.get(ibisName);
            resolver.resolve(ibisId, ibisName);
            id = this.idMap.get(ibisId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Mapped Identifier: " + ibisId + " to:" + id);
        }
        return id;
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        return this.ManageableMapper.getManagementProperty(key);
    }

    public Map<String, String> managementProperties() {
        return this.ManageableMapper.managementProperties();
    }

    public void printManagementProperties(PrintStream stream) {
        this.ManageableMapper.printManagementProperties(stream);
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        this.ManageableMapper.setManagementProperties(properties);
    }

    public void setManagementProperty(String key, String value) throws NoSuchPropertyException {
        this.ManageableMapper.setManagementProperty(key, value);
    }

    public SendPortIdentifier mapSendPortIdentifier(SendPortIdentifier johnDoe, String ibisName) throws IOException {
        MultiSendPortIdentifier id = null;
        if (this.sendPortIdMap.containsKey(johnDoe)) {
            return this.sendPortIdMap.get(johnDoe);
        }
        id = new MultiSendPortIdentifier(this.mapIdentifier(johnDoe.ibisIdentifier(), ibisName), johnDoe.name());
        this.sendPortIdMap.put(johnDoe, id);
        return id;
    }

    public ReceivePortIdentifier mapReceivePortIdentifier(ReceivePortIdentifier johnDoe, String ibisName) throws IOException {
        MultiReceivePortIdentifier id = null;
        if (this.receivePortIdMap.containsKey(johnDoe)) {
            return this.receivePortIdMap.get(johnDoe);
        }
        id = new MultiReceivePortIdentifier(this.mapIdentifier(johnDoe.ibisIdentifier(), ibisName), johnDoe.name());
        this.receivePortIdMap.put(johnDoe, id);
        return id;
    }

    public void resolved(MultiIbisIdentifier id) {
        for (String subIbisName : this.subIbisMap.keySet()) {
            IbisIdentifier subId = id.subIdForIbis(subIbisName);
            if (subId == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Resolved: " + subId + " to: " + id);
            }
            this.idMap.put(subId, id);
        }
    }

    public boolean isResolved(IbisIdentifier toResolve) {
        return this.idMap.get(toResolve) != null;
    }
}

