/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc.util;

import java.util.LinkedList;

public class ByteArrayCache {
    private static final int DEFAULT_MAX = 100;
    private LinkedList<byte[]> cache = new LinkedList();
    private final int maxSize;
    private final int arraySize;

    public ByteArrayCache(int arraySize) {
        this(arraySize, 100);
    }

    public ByteArrayCache(int arraySize, int maxArrays) {
        this.maxSize = maxArrays;
        this.arraySize = arraySize;
    }

    public synchronized void put(byte[] array) {
        if (this.cache.size() < this.maxSize && array.length == this.arraySize) {
            this.cache.addLast(array);
        }
    }

    public synchronized byte[] get(int len) {
        if (len <= this.arraySize && this.cache.size() > 0) {
            return this.cache.removeLast();
        }
        return new byte[len];
    }
}

