/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc.io;

import ibis.ipl.impl.stacking.lrmc.util.Message;
import ibis.ipl.impl.stacking.lrmc.util.MessageCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LrmcInputStream
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(LrmcInputStream.class);
    private final int source;
    private final ArrayList<Message> queue = new ArrayList();
    private Message current = null;
    private int index = 0;
    private int currentID = 0;
    private int currentNum = 0;
    private boolean finish = false;
    private MessageCache cache;

    public LrmcInputStream(int source, MessageCache cache) {
        this.source = source;
        this.cache = cache;
    }

    public synchronized void terminate() {
        this.finish = true;
        this.notifyAll();
    }

    public int getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean haveData() {
        if (this.current != null && this.index < this.current.len) {
            return true;
        }
        LrmcInputStream lrmcInputStream = this;
        synchronized (lrmcInputStream) {
            return this.queue.size() != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMessage(Message m) {
        LrmcInputStream lrmcInputStream = this;
        synchronized (lrmcInputStream) {
            this.queue.add(m);
            this.notify();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Queued message " + m.id + "/" + m.num + "(" + m.len + ")");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMessage() {
        LrmcInputStream lrmcInputStream = this;
        synchronized (lrmcInputStream) {
            while (!this.finish && this.queue.size() == 0) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            if (this.finish) {
                this.current = null;
                return;
            }
            this.current = this.queue.remove(0);
        }
        this.index = 0;
        if (logger.isDebugEnabled()) {
            logger.debug("Dequeued message " + this.current.id + "/" + this.current.num + "(" + this.current.len + ")");
        }
    }

    private void checkMessage() throws IOException {
        if (this.currentID == 0) {
            while (this.current.num != 0) {
                logger.info("___ Dropping packet " + this.current.id + "/" + this.current.num + " [" + this.current.len + "] " + "since it's not the first one!");
                this.freeMessage();
                this.getMessage();
                if (this.current != null) continue;
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Starting new series " + this.current.id);
            }
            this.currentID = this.current.id;
            this.currentNum = 0;
        } else if (this.currentID != this.current.id || this.currentNum != this.current.num) {
            String tmp = "Inconsistency discovered in multicast packet series, current series " + this.currentID + "/" + this.currentNum + " next packet " + this.current.id + "/" + this.current.num;
            this.currentID = 0;
            throw new IOException(tmp);
        }
    }

    private void freeMessage() {
        if (logger.isDebugEnabled()) {
            logger.debug("Freed message " + this.current.id + "/" + this.current.num + " last = " + this.current.last);
        }
        if (this.current.last) {
            this.currentID = 0;
            this.currentNum = 0;
        } else {
            ++this.currentNum;
        }
        this.cache.put(this.current);
        this.current = null;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.current == null) {
            this.getMessage();
        }
        if (this.current == null) {
            throw new IOException("Someone wants us to stop ...");
        }
        this.checkMessage();
        if (this.current == null) {
            throw new IOException("Someone wants us to stop ...");
        }
        int leftover = this.current.len - this.index;
        if (leftover <= len) {
            if (logger.isDebugEnabled()) {
                logger.debug("Copying " + this.index + " " + this.current.buffer.length + " " + off + " " + leftover);
            }
            System.arraycopy(this.current.buffer, this.index, b, off, leftover);
            this.freeMessage();
            return leftover;
        }
        System.arraycopy(this.current.buffer, this.index, b, off, len);
        this.index += len;
        return len;
    }

    @Override
    public int read() throws IOException {
        byte[] tmp = new byte[1];
        this.read(tmp, 0, 1);
        return tmp[0];
    }
}

