/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc;

import ibis.ipl.ConnectionFailedException;
import ibis.ipl.ConnectionsFailedException;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePortIdentifier;
import ibis.ipl.SendPort;
import ibis.ipl.SendPortDisconnectUpcall;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.WriteMessage;
import ibis.ipl.impl.stacking.lrmc.LrmcIbis;
import ibis.ipl.impl.stacking.lrmc.StackingWriteMessage;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;

public class StackingSendPort
implements SendPort {
    final SendPort base;

    public StackingSendPort(PortType type, LrmcIbis ibis, String name, SendPortDisconnectUpcall connectUpcall, Properties props) throws IOException {
        if (connectUpcall != null) {
            connectUpcall = new DisconnectUpcaller(this, connectUpcall);
            this.base = ibis.base.createSendPort(type, name, connectUpcall, props);
        } else {
            this.base = ibis.base.createSendPort(type, name, null, props);
        }
    }

    public void close() throws IOException {
        this.base.close();
    }

    public void connect(ReceivePortIdentifier receiver) throws ConnectionFailedException {
        this.connect(receiver, 0L, true);
    }

    public void connect(ReceivePortIdentifier receiver, long timeoutMillis, boolean fillTimeout) throws ConnectionFailedException {
        this.base.connect(receiver, timeoutMillis, fillTimeout);
    }

    public ReceivePortIdentifier connect(IbisIdentifier id, String name) throws ConnectionFailedException {
        return this.connect(id, name, 0L, true);
    }

    public ReceivePortIdentifier connect(IbisIdentifier id, String name, long timeoutMillis, boolean fillTimeout) throws ConnectionFailedException {
        return this.base.connect(id, name, timeoutMillis, fillTimeout);
    }

    public void connect(ReceivePortIdentifier[] ports) throws ConnectionsFailedException {
        this.connect(ports, 0L, true);
    }

    public void connect(ReceivePortIdentifier[] ports, long timeoutMillis, boolean fillTimeout) throws ConnectionsFailedException {
        this.base.connect(ports, timeoutMillis, fillTimeout);
    }

    public ReceivePortIdentifier[] connect(Map<IbisIdentifier, String> ports) throws ConnectionsFailedException {
        return this.connect(ports, 0L, true);
    }

    public ReceivePortIdentifier[] connect(Map<IbisIdentifier, String> ports, long timeoutMillis, boolean fillTimeout) throws ConnectionsFailedException {
        return this.base.connect(ports, timeoutMillis, fillTimeout);
    }

    public ReceivePortIdentifier[] connectedTo() {
        return this.base.connectedTo();
    }

    public void disconnect(ReceivePortIdentifier receiver) throws IOException {
        this.base.disconnect(receiver);
    }

    public void disconnect(IbisIdentifier id, String name) throws IOException {
        this.base.disconnect(id, name);
    }

    public PortType getPortType() {
        return this.base.getPortType();
    }

    public SendPortIdentifier identifier() {
        return this.base.identifier();
    }

    public ReceivePortIdentifier[] lostConnections() {
        return this.base.lostConnections();
    }

    public String name() {
        return this.base.name();
    }

    public WriteMessage newMessage() throws IOException {
        return new StackingWriteMessage(this.base.newMessage(), this);
    }

    public Map<String, String> managementProperties() {
        return this.base.managementProperties();
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        return this.base.getManagementProperty(key);
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        this.base.setManagementProperties(properties);
    }

    public void setManagementProperty(String key, String val) throws NoSuchPropertyException {
        this.base.setManagementProperty(key, val);
    }

    public void printManagementProperties(PrintStream stream) {
        this.base.printManagementProperties(stream);
    }

    private static final class DisconnectUpcaller
    implements SendPortDisconnectUpcall {
        StackingSendPort port;
        SendPortDisconnectUpcall upcaller;

        public DisconnectUpcaller(StackingSendPort port, SendPortDisconnectUpcall upcaller) {
            this.port = port;
            this.upcaller = upcaller;
        }

        public void lostConnection(SendPort me, ReceivePortIdentifier johnDoe, Throwable reason) {
            this.upcaller.lostConnection((SendPort)this.port, johnDoe, reason);
        }
    }
}

