/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc;

import ibis.io.DataInputStream;
import ibis.io.DataOutputStream;
import ibis.io.SerializationFactory;
import ibis.io.SerializationInput;
import ibis.io.SerializationOutput;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.PortType;
import ibis.ipl.impl.stacking.lrmc.InputStreams;
import ibis.ipl.impl.stacking.lrmc.LabelRoutingMulticast;
import ibis.ipl.impl.stacking.lrmc.LrmcIbis;
import ibis.ipl.impl.stacking.lrmc.LrmcReadMessage;
import ibis.ipl.impl.stacking.lrmc.LrmcReceivePort;
import ibis.ipl.impl.stacking.lrmc.LrmcSendPort;
import ibis.ipl.impl.stacking.lrmc.io.BufferedArrayInputStream;
import ibis.ipl.impl.stacking.lrmc.io.BufferedArrayOutputStream;
import ibis.ipl.impl.stacking.lrmc.io.LrmcInputStream;
import ibis.ipl.impl.stacking.lrmc.io.LrmcOutputStream;
import ibis.ipl.impl.stacking.lrmc.io.MessageReceiver;
import ibis.ipl.impl.stacking.lrmc.util.Message;
import ibis.ipl.impl.stacking.lrmc.util.MessageCache;
import ibis.util.TypedProperties;
import java.io.IOException;

public class Multicaster
implements MessageReceiver {
    private final int MESSAGE_SIZE;
    private final int MESSAGE_CACHE_SIZE;
    LabelRoutingMulticast lrmc;
    final PortType portType;
    final String name;
    private LrmcOutputStream os;
    BufferedArrayOutputStream bout;
    BufferedArrayInputStream bin;
    SerializationOutput sout;
    SerializationInput sin;
    private long totalData = 0L;
    private long lastBytesWritten = 0L;
    private MessageCache cache;
    private boolean finish = false;
    private boolean receiverDone = false;
    private Thread receiver = null;
    private InputStreams inputStreams = new InputStreams();
    private IbisIdentifier[] destination = null;
    LrmcSendPort sendPort = null;
    LrmcReceivePort receivePort = null;

    public Multicaster(LrmcIbis ibis, PortType type, String name) throws IOException {
        TypedProperties tp = new TypedProperties(ibis.properties());
        this.MESSAGE_SIZE = tp.getIntProperty("lrmc.messageSize", 8192);
        this.MESSAGE_CACHE_SIZE = tp.getIntProperty("lrmc.messageCacheSize", 1500);
        this.cache = new MessageCache(this.MESSAGE_CACHE_SIZE, this.MESSAGE_SIZE);
        this.lrmc = new LabelRoutingMulticast(ibis, this, this.cache, name);
        this.os = new LrmcOutputStream(this.lrmc, this.cache);
        this.bout = new BufferedArrayOutputStream(this.os, this.MESSAGE_SIZE);
        this.bin = new BufferedArrayInputStream(null);
        String serialization = type.hasCapability("serialization.data") ? "data" : (type.hasCapability("serialization.object.sun") ? "sun" : (type.hasCapability("serialization.object.ibis") ? "ibis" : (type.hasCapability("serialization.object") ? "object" : "byte")));
        this.sout = SerializationFactory.createSerializationOutput((String)serialization, (DataOutputStream)this.bout);
        this.sin = SerializationFactory.createSerializationInput((String)serialization, (DataInputStream)this.bin);
        this.portType = type;
        this.name = name;
    }

    public synchronized void setDestination(IbisIdentifier[] dest) {
        this.destination = dest;
        this.cache.setDestinationSize(dest.length);
    }

    @Override
    public void gotDone(int id) {
    }

    @Override
    public boolean gotMessage(Message m) {
        LrmcInputStream tmp = this.inputStreams.get(m.sender, this.cache);
        return this.inputStreams.hasData(tmp, m);
    }

    void initializeSend(IbisIdentifier[] destinations) throws IOException {
        if (this.destination != destinations) {
            this.destination = destinations;
            this.lrmc.setDestination(destinations);
        }
        this.bout.resetBytesWritten();
        this.os.reset();
        this.sout.reset(true);
    }

    long finalizeSend() throws IOException {
        this.sout.flush();
        this.bout.forcedFlush();
        this.lastBytesWritten = this.bout.bytesWritten();
        this.totalData += this.lastBytesWritten;
        return this.lastBytesWritten;
    }

    long finalizeRead(LrmcInputStream stream) {
        this.inputStreams.returnStream(stream);
        long sz = this.bin.bytesRead();
        this.totalData += sz;
        return sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LrmcReadMessage receive() {
        LrmcReadMessage o;
        Multicaster multicaster = this;
        synchronized (multicaster) {
            if (this.finish) {
                return null;
            }
            this.receiverDone = false;
            this.receiver = Thread.currentThread();
        }
        try {
            LrmcInputStream stream = this.inputStreams.getNextFilledStream();
            if (stream == null) {
                LrmcReadMessage lrmcReadMessage = null;
                return lrmcReadMessage;
            }
            this.bin.setInputStream(stream);
            this.bin.resetBytesRead();
            o = new LrmcReadMessage(this, stream);
        }
        finally {
            Multicaster multicaster2 = this;
            synchronized (multicaster2) {
                this.receiverDone = true;
                if (this.finish) {
                    this.notifyAll();
                    return null;
                }
                this.receiver = null;
            }
        }
        return o;
    }

    public long bytesRead() {
        return this.bin.bytesRead();
    }

    public long bytesWritten() {
        return this.bout.bytesWritten();
    }

    public long totalBytes() {
        return this.totalData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Multicaster multicaster = this;
        synchronized (multicaster) {
            this.finish = true;
            this.inputStreams.terminate();
            this.notifyAll();
            if (this.receiver != null) {
                while (!this.receiverDone) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        try {
            this.os.close();
            this.sin.close();
            this.lrmc.done();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void removeReceivePort() {
        this.receivePort = null;
        if (this.sendPort == null) {
            this.done();
        }
    }

    public void removeSendPort() {
        this.sendPort = null;
        if (this.receivePort == null) {
            this.done();
        }
    }
}

