/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.util.messagecombining;

import ibis.io.DataOutputStream;
import ibis.io.Replacer;
import ibis.io.SerializationFactory;
import ibis.io.SerializationOutput;
import ibis.ipl.SendPort;
import ibis.ipl.WriteMessage;
import ibis.ipl.util.messagecombining.MessageCombiner;
import ibis.ipl.util.messagecombining.StoreArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CombiningWriteMessage
implements WriteMessage {
    private SerializationOutput out;
    private MessageCombiner sp;
    private StoreArrayOutputStream storeOut;
    private String ser;
    private Replacer replacer;

    protected CombiningWriteMessage(MessageCombiner sp, StoreArrayOutputStream storeOut, String ser) {
        this.storeOut = storeOut;
        this.sp = sp;
        this.ser = ser;
    }

    protected void clear() throws IOException {
        if (this.out == null) {
            this.out = SerializationFactory.createSerializationOutput((String)this.ser, (DataOutputStream)this.storeOut);
            if (this.replacer != null) {
                this.out.setReplacer(this.replacer);
            }
        }
        this.out.reset(true);
    }

    protected void setReplacer(Replacer r) throws IOException {
        this.replacer = r;
    }

    public int send() throws IOException {
        return 0;
    }

    public void sync(int arg0) throws IOException {
    }

    public void reset() throws IOException {
        this.out.reset();
    }

    public long finish() throws IOException {
        this.out.reset();
        this.out.flush();
        return this.sp.messageIsFinished();
    }

    public void finish(IOException arg0) {
        try {
            this.finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long bytesWritten() throws IOException {
        throw new IOException("Bytes Written not supported");
    }

    public SendPort localPort() {
        return this.sp.getSendPort();
    }

    public void writeBoolean(boolean arg0) throws IOException {
        this.out.writeBoolean(arg0);
    }

    public void writeByte(byte arg0) throws IOException {
        this.out.writeByte(arg0);
    }

    public void writeChar(char arg0) throws IOException {
        this.out.writeChar(arg0);
    }

    public void writeShort(short arg0) throws IOException {
        this.out.writeShort(arg0);
    }

    public void writeInt(int arg0) throws IOException {
        this.out.writeInt(arg0);
    }

    public void writeLong(long arg0) throws IOException {
        this.out.writeLong(arg0);
    }

    public void writeFloat(float arg0) throws IOException {
        this.out.writeFloat(arg0);
    }

    public void writeDouble(double arg0) throws IOException {
        this.out.writeDouble(arg0);
    }

    public void writeString(String arg0) throws IOException {
        this.out.writeString(arg0);
    }

    public void writeObject(Object arg0) throws IOException {
        this.out.writeObject(arg0);
    }

    public void writeArray(boolean[] arg0) throws IOException {
        this.out.writeArray(arg0);
    }

    public void writeArray(byte[] arg0) throws IOException {
        this.out.writeArray(arg0);
    }

    public void writeArray(char[] arg0) throws IOException {
        this.out.writeArray(arg0);
    }

    public void writeArray(short[] arg0) throws IOException {
        this.out.writeArray(arg0);
    }

    public void writeArray(int[] arg0) throws IOException {
        this.out.writeArray(arg0);
    }

    public void writeArray(long[] arg0) throws IOException {
        this.out.writeArray(arg0);
    }

    public void writeArray(float[] arg0) throws IOException {
        this.out.writeArray(arg0);
    }

    public void writeArray(double[] arg0) throws IOException {
        this.out.writeArray(arg0);
    }

    public void writeArray(Object[] arg0) throws IOException {
        this.out.writeArray(arg0);
    }

    public void writeArray(boolean[] arg0, int arg1, int arg2) throws IOException {
        this.out.writeArray(arg0, arg1, arg2);
    }

    public void writeArray(byte[] arg0, int arg1, int arg2) throws IOException {
        this.out.writeArray(arg0, arg1, arg2);
    }

    public void writeArray(char[] arg0, int arg1, int arg2) throws IOException {
        this.out.writeArray(arg0, arg1, arg2);
    }

    public void writeArray(short[] arg0, int arg1, int arg2) throws IOException {
        this.out.writeArray(arg0, arg1, arg2);
    }

    public void writeArray(int[] arg0, int arg1, int arg2) throws IOException {
        this.out.writeArray(arg0, arg1, arg2);
    }

    public void writeArray(long[] arg0, int arg1, int arg2) throws IOException {
        this.out.writeArray(arg0, arg1, arg2);
    }

    public void writeArray(float[] arg0, int arg1, int arg2) throws IOException {
        this.out.writeArray(arg0, arg1, arg2);
    }

    public void writeArray(double[] arg0, int arg1, int arg2) throws IOException {
        this.out.writeArray(arg0, arg1, arg2);
    }

    public void writeArray(Object[] arg0, int arg1, int arg2) throws IOException {
        this.out.writeArray(arg0, arg1, arg2);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public int capacity() throws IOException {
        return -1;
    }

    public int remaining() throws IOException {
        return -1;
    }

    public void writeByteBuffer(ByteBuffer value) throws IOException {
        this.out.writeByteBuffer(value);
    }
}

