/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.support.vivaldi;

import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.registry.Registry;
import ibis.ipl.support.Client;
import ibis.ipl.support.Connection;
import ibis.ipl.support.vivaldi.ConnectionHandler;
import ibis.ipl.support.vivaldi.Coordinates;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.util.ThreadPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VivaldiClient
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(VivaldiClient.class);
    public static final int CONNECTION_TIMEOUT = 10000;
    public static final int PING_INTERVAL = 10000;
    public static final int PING_COUNT = 4;
    private static final int CONNECTION_BACKLOG = 10;
    private final Registry registry;
    private final VirtualSocketFactory virtualSocketFactory;
    private final VirtualServerSocket serverSocket;
    private boolean ended;
    private Coordinates coordinates;

    public VivaldiClient(Properties properties, Registry registry) throws IOException {
        this.registry = registry;
        this.coordinates = new Coordinates();
        String clientID = properties.getProperty("ibis.local.id");
        Client client = Client.getOrCreateClient(clientID, properties, 0);
        this.virtualSocketFactory = client.getFactory();
        this.serverSocket = this.virtualSocketFactory.createServerSocket(305, 10, null);
        new ConnectionHandler(this.serverSocket, this);
        ThreadPool.createNew((Runnable)this, (String)"Vivaldi Client");
    }

    public double ping(IbisIdentifier identifier, boolean updateCoordinates) throws IOException {
        int read;
        double result = Double.MAX_VALUE;
        if (logger.isDebugEnabled()) {
            logger.debug("ping to " + identifier);
        }
        Connection connection = new Connection(identifier, 10000, true, this.virtualSocketFactory, 305);
        DataInputStream in = connection.in();
        DataOutputStream out = connection.out();
        byte[] coordinateBytes = new byte[32];
        int offset = 0;
        for (int remaining = 32; remaining > 0; remaining -= read) {
            read = ((InputStream)in).read(coordinateBytes, offset, remaining);
            if (read == -1) {
                throw new IOException("could not read Coordinates");
            }
            offset += read;
        }
        Coordinates remoteCoordinates = new Coordinates(coordinateBytes);
        for (int i = 0; i < 4; ++i) {
            long start = System.nanoTime();
            ((OutputStream)out).write(i);
            ((OutputStream)out).flush();
            int reply = ((InputStream)in).read();
            long end = System.nanoTime();
            if (reply != i) {
                throw new IOException("ping failed, wrong reply: " + reply);
            }
            long time = end - start;
            double rtt = (double)time / 1000000.0;
            if (!(rtt < result)) continue;
            result = rtt;
        }
        connection.close();
        if (updateCoordinates) {
            this.updateCoordinates(remoteCoordinates, result);
        }
        if (logger.isInfoEnabled()) {
            logger.info("vivaldi distance to " + identifier + " is " + remoteCoordinates.distance(this.getCoordinates()) + " actual distance is " + result + " ms, coordinates now " + this.getCoordinates());
        }
        return result;
    }

    public void handleConnection(Connection connection) {
        Thread.currentThread().setPriority(10);
        try {
            DataOutputStream out = connection.out();
            DataInputStream in = connection.in();
            out.write(this.getCoordinates().toBytes());
            out.flush();
            for (int i = 0; i < 4; ++i) {
                int read = in.read();
                out.write(read);
                out.flush();
            }
        }
        catch (IOException e) {
            logger.error("error on handling ping", (Throwable)e);
        }
        connection.close();
        Thread.currentThread().setPriority(5);
    }

    public void start() {
        ThreadPool.createNew((Runnable)this, (String)"vivaldi");
        if (logger.isInfoEnabled()) {
            logger.info("Started Vivaldi service");
        }
    }

    private synchronized void updateCoordinates(Coordinates remoteCoordinates, double rtt) {
        this.coordinates = this.coordinates.update(remoteCoordinates, rtt);
        if (logger.isDebugEnabled()) {
            logger.debug("coordinates now " + this.coordinates);
        }
    }

    public synchronized Coordinates getCoordinates() {
        return this.coordinates;
    }

    private synchronized boolean ended() {
        return this.ended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        VivaldiClient vivaldiClient = this;
        synchronized (vivaldiClient) {
            this.ended = true;
            this.notifyAll();
        }
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.virtualSocketFactory.end();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(10);
        while (!this.ended()) {
            block6: {
                IbisIdentifier randomNode = this.registry.getRandomPoolMember();
                if (randomNode != null && !randomNode.equals((Object)this.registry.getIbisIdentifier())) {
                    try {
                        this.ping(randomNode, true);
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block6;
                        logger.debug("error on pinging random node " + randomNode, (Throwable)e);
                    }
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

