/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.server;

import ibis.ipl.IbisFactory;
import ibis.ipl.registry.Registry;
import ibis.util.TypedProperties;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ServerProperties {
    public static final String PREFIX = "ibis.server.";
    public static final String START_HUB = "ibis.server.start.hub";
    public static final String HUB_ONLY = "ibis.server.hub.only";
    public static final String HUB_ADDRESS_FILE = "ibis.server.hub.address.file";
    public static final String PORT = "ibis.server.port";
    public static final String PRINT_EVENTS = "ibis.server.print.events";
    public static final String PRINT_STATS = "ibis.server.print.stats";
    public static final String PRINT_ERRORS = "ibis.server.print.errors";
    public static final String REMOTE = "ibis.server.remote";
    public static final String SERVICES = "ibis.server.services";
    public static final String VIZ_INFO = "ibis.server.viz.info";
    public static final String HUB_ADDRESSES = "ibis.server.hub.addresses";
    public static final String implementationVersion;
    public static final int DEFAULT_PORT = 8888;
    private static final String[][] propertiesList;

    public static TypedProperties getHardcodedProperties() {
        TypedProperties properties = new TypedProperties();
        for (String[] element : propertiesList) {
            if (element[1] == null) continue;
            properties.setProperty(element[0], element[1]);
        }
        return properties;
    }

    public static Map<String, String> getDescriptions() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String[] element : propertiesList) {
            result.put(element[0], element[2]);
        }
        return result;
    }

    static {
        String version = Registry.class.getPackage().getImplementationVersion();
        if (version == null || version.equals("0.0")) {
            version = IbisFactory.getManifestProperty((String)"support.version");
        }
        if (version == null) {
            throw new Error("Cannot get version for server");
        }
        implementationVersion = version;
        propertiesList = new String[][]{{HUB_ADDRESSES, null, "String: comma-separated list of hub addresses."}, {START_HUB, "true", "Boolean: if true, also start a hub at the server."}, {HUB_ONLY, "false", "Boolean: if true, only start a hub, not the rest of the server."}, {HUB_ADDRESS_FILE, null, "String: file where the address of the hub is printed to (and deleted on exit)."}, {PORT, Integer.toString(8888), "Integer: port to which the server binds."}, {PRINT_EVENTS, "false", "Boolean: if true, events of services are printed to standard out."}, {PRINT_ERRORS, "false", "Boolean: if true, details of errors (like stacktraces) are printed."}, {PRINT_STATS, "false", "Boolean: if true, statistics are printed to standard out regularly."}, {REMOTE, "false", "Boolean: If true, the server listens to stdin for commands and responds on stdout."}, {VIZ_INFO, null, "String: info for smartsockets visualization."}};
    }
}

