/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.gossip;

import ibis.ipl.registry.gossip.ARRGCache;
import ibis.ipl.registry.gossip.ARRGCacheEntry;
import ibis.ipl.registry.statistics.Statistics;
import ibis.ipl.support.Connection;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.IOException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ARRG
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ARRG.class);
    private static final int GOSSIP_TIMEOUT = 1000;
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int SERVER_CONNECT_TIMEOUT = 120000;
    private static final int CACHE_SIZE = 100;
    private static final int GOSSIP_SIZE = 30;
    private static final long DEAD_TIMEOUT = 300000L;
    private final VirtualSocketFactory socketFactory;
    private final VirtualSocketAddress bootstrapAddress;
    private final String poolName;
    private final Statistics statistics;
    private final ARRGCacheEntry self;
    private final ARRGCache cache;
    private final ARRGCache fallbackCache;
    private boolean ended;
    private long lastGossip;

    ARRG(VirtualSocketAddress address, boolean arrgOnly, VirtualSocketAddress[] bootstrapList, VirtualSocketAddress bootstrapAddress, String poolName, VirtualSocketFactory socketFactory, Statistics statistics) {
        this.socketFactory = socketFactory;
        this.poolName = poolName;
        this.bootstrapAddress = bootstrapAddress;
        this.statistics = statistics;
        this.self = new ARRGCacheEntry(address, arrgOnly);
        this.cache = new ARRGCache(100);
        this.fallbackCache = new ARRGCache(100);
        for (VirtualSocketAddress bootstrapEntry : bootstrapList) {
            ARRGCacheEntry entry = new ARRGCacheEntry(bootstrapEntry, true);
            this.cache.add(entry);
            this.fallbackCache.add(entry);
        }
        this.lastGossip = System.currentTimeMillis();
    }

    @Override
    public synchronized void start() {
        super.setDaemon(true);
        super.start();
    }

    public String getPoolName() {
        return this.poolName;
    }

    synchronized void end() {
        this.ended = true;
        this.notifyAll();
    }

    synchronized boolean ended() {
        return this.ended;
    }

    private synchronized void resetLastGossip() {
        this.lastGossip = System.currentTimeMillis();
    }

    synchronized boolean isDead() {
        return System.currentTimeMillis() > this.lastGossip + 300000L;
    }

    void handleGossip(Connection connection) throws IOException {
        ARRGCacheEntry peerEntry = new ARRGCacheEntry(connection.in());
        int receiveCount = connection.in().readInt();
        ARRGCacheEntry[] receivedEntries = new ARRGCacheEntry[receiveCount];
        for (int i = 0; i < receiveCount; ++i) {
            receivedEntries[i] = new ARRGCacheEntry(connection.in());
        }
        connection.sendOKReply();
        this.self.writeTo(connection.out());
        ARRGCacheEntry[] sendEntries = this.cache.getRandomEntries(30, true);
        connection.out().writeInt(sendEntries.length);
        for (ARRGCacheEntry entry : sendEntries) {
            entry.writeTo(connection.out());
        }
        connection.out().flush();
        connection.close();
        this.cache.add(peerEntry);
        this.cache.add(receivedEntries);
        this.resetLastGossip();
        if (logger.isDebugEnabled()) {
            logger.debug("bootstrap service for " + this.poolName + " received request from " + peerEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gossip(VirtualSocketAddress victim, int timeout, boolean fillTimeout) throws IOException {
        long start = System.currentTimeMillis();
        if (victim == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("no victim specified");
            }
            return;
        }
        if (victim.equals((Object)this.self.getAddress())) {
            if (logger.isDebugEnabled()) {
                logger.debug("not gossiping with outselves");
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("gossiping with " + victim);
        }
        ARRGCacheEntry[] sendEntries = this.cache.getRandomEntries(30, true);
        Connection connection = null;
        try {
            connection = new Connection(victim, timeout, fillTimeout, this.socketFactory);
            connection.out().writeByte(54);
            connection.out().writeByte(0);
            connection.out().writeUTF(this.poolName);
            this.self.writeTo(connection.out());
            connection.out().writeInt(sendEntries.length);
            for (ARRGCacheEntry entry : sendEntries) {
                entry.writeTo(connection.out());
            }
            connection.getAndCheckReply();
            ARRGCacheEntry peerEntry = new ARRGCacheEntry(connection.in());
            int receiveCount = connection.in().readInt();
            ARRGCacheEntry[] receivedEntries = new ARRGCacheEntry[receiveCount];
            for (int i = 0; i < receiveCount; ++i) {
                receivedEntries[i] = new ARRGCacheEntry(connection.in());
            }
            connection.close();
            this.cache.add(peerEntry);
            this.cache.add(receivedEntries);
            this.resetLastGossip();
            if (this.statistics != null) {
                this.statistics.add((byte)0, System.currentTimeMillis() - start, connection.read(), connection.written(), false);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    VirtualSocketAddress getRandomMember() {
        ARRGCacheEntry result = this.cache.getRandomEntry(false);
        if (result == null) {
            return null;
        }
        return result.getAddress();
    }

    VirtualSocketAddress[] getRandomMembers(int size) {
        ARRGCacheEntry[] entries;
        HashSet<VirtualSocketAddress> result = new HashSet<VirtualSocketAddress>();
        for (ARRGCacheEntry entry : entries = this.cache.getRandomEntries(size, false)) {
            if (entry.isArrgOnly()) continue;
            result.add(entry.getAddress());
        }
        return result.toArray(new VirtualSocketAddress[0]);
    }

    VirtualSocketAddress[] getMembers() {
        ARRGCacheEntry[] entries;
        HashSet<VirtualSocketAddress> result = new HashSet<VirtualSocketAddress>();
        for (ARRGCacheEntry entry : entries = this.cache.getEntries(false)) {
            if (entry.isArrgOnly()) continue;
            result.add(entry.getAddress());
        }
        for (ARRGCacheEntry entry : entries = this.fallbackCache.getEntries(false)) {
            if (entry.isArrgOnly()) continue;
            result.add(entry.getAddress());
        }
        return result.toArray(new VirtualSocketAddress[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.ended()) {
            boolean success;
            block17: {
                ARRGCacheEntry victim;
                block16: {
                    victim = this.cache.getRandomEntry(true);
                    success = false;
                    if (victim != null) {
                        try {
                            this.gossip(victim.getAddress(), 30000, false);
                            this.fallbackCache.add(victim);
                            success = true;
                        }
                        catch (IOException e) {
                            if (!logger.isDebugEnabled()) break block16;
                            logger.debug("could not gossip with " + victim, (Throwable)e);
                        }
                    }
                }
                if (!success && (victim = this.fallbackCache.getRandomEntry(true)) != null) {
                    try {
                        this.gossip(victim.getAddress(), 30000, false);
                        success = true;
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block17;
                        logger.debug("could not gossip with fallback entry: " + victim, (Throwable)e);
                    }
                }
            }
            if (!success && this.bootstrapAddress != null) {
                try {
                    this.gossip(this.bootstrapAddress, 120000, true);
                    success = true;
                }
                catch (IOException e) {
                    logger.error("could not gossip with bootstrap server at " + this.bootstrapAddress, (Throwable)e);
                }
            }
            ARRG aRRG = this;
            synchronized (aRRG) {
                long timeout = (long)(Math.random() * 1000.0) + 1L;
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("waiting " + timeout + " ms");
                    }
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    public Statistics getStatistics() {
        return this.statistics;
    }
}

