/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central.client;

import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisConfigurationException;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.registry.central.Election;
import ibis.ipl.registry.central.ElectionSet;
import ibis.ipl.registry.central.Event;
import ibis.ipl.registry.central.EventList;
import ibis.ipl.registry.central.ListMemberSet;
import ibis.ipl.registry.central.Member;
import ibis.ipl.registry.central.MemberSet;
import ibis.ipl.registry.central.TreeMemberSet;
import ibis.ipl.registry.central.client.Registry;
import ibis.ipl.registry.statistics.Statistics;
import ibis.util.TypedProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Pool {
    private static final Logger logger = LoggerFactory.getLogger(Pool.class);
    private final String poolName;
    private final boolean closedWorld;
    private final int size;
    private final long heartbeatInterval;
    private final MemberSet members;
    private final ElectionSet elections;
    private final EventList eventList;
    private final Registry registry;
    private final Statistics statistics;
    private boolean initialized;
    private boolean closed;
    private boolean stopped;
    private boolean terminated;
    private Event closeEvent;
    private Event terminateEvent;
    private int time;

    Pool(IbisCapabilities capabilities, TypedProperties properties, Registry registry, Statistics statistics) {
        this.registry = registry;
        this.statistics = statistics;
        if (statistics != null) {
            statistics.newPoolSize(0);
        }
        this.members = properties.getBooleanProperty("ibis.registry.central.tree") ? new TreeMemberSet() : new ListMemberSet();
        this.elections = new ElectionSet();
        this.eventList = new EventList();
        this.time = -1;
        this.initialized = false;
        this.closed = false;
        this.closeEvent = null;
        this.terminated = false;
        this.terminateEvent = null;
        this.stopped = false;
        this.poolName = properties.getProperty("ibis.pool.name");
        if (this.poolName == null) {
            throw new IbisConfigurationException("cannot initialize registry, property ibis.pool.name is not specified");
        }
        this.closedWorld = capabilities.hasCapability("closed.world");
        if (this.closedWorld) {
            try {
                this.size = properties.getIntProperty("ibis.pool.size");
            }
            catch (NumberFormatException e) {
                throw new IbisConfigurationException("could not start registry for a closed world ibis, required property: ibis.pool.size undefined", (Throwable)e);
            }
        } else {
            this.size = -1;
        }
        this.heartbeatInterval = properties.getIntProperty("ibis.registry.central.heartbeat.interval") * 1000;
    }

    synchronized Event[] getEventsFrom(int start) {
        return this.eventList.getList(start);
    }

    String getName() {
        return this.poolName;
    }

    boolean isClosedWorld() {
        return this.closedWorld;
    }

    int getSize() {
        return this.size;
    }

    synchronized Member getRandomMember() {
        return this.members.getRandom();
    }

    synchronized int getNextRequiredEvent() {
        return this.eventList.getNextRequiredEvent();
    }

    synchronized int getTime() {
        return this.time;
    }

    synchronized boolean isInitialized() {
        return this.initialized;
    }

    synchronized boolean isStopped() {
        return this.stopped;
    }

    synchronized boolean isMember(ibis.ipl.impl.IbisIdentifier ibis) {
        return this.members.contains(ibis);
    }

    public synchronized boolean mustReportMaybeDead(IbisIdentifier ibisIdentifier) {
        Member member = this.members.get(ibisIdentifier.name());
        if (member == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("user reporting ibis " + ibisIdentifier + "  which is not in pool, not reporting");
            }
            return false;
        }
        if (member.getTime() > System.currentTimeMillis() - this.heartbeatInterval) {
            if (logger.isDebugEnabled()) {
                logger.debug("user reporting member " + ibisIdentifier + "  recently reported already, skipping this time");
            }
            return false;
        }
        member.updateTime();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newEventsReceived(Event[] events) {
        Pool pool = this;
        synchronized (pool) {
            this.eventList.add(events);
        }
        this.handleEvents();
    }

    synchronized void purgeHistoryUpto(int time) {
        if (this.time != -1 && this.time < time) {
            logger.error("EEP! we are asked to purge the history of events we still need. Our time =  " + this.time + " purge time = " + time);
            return;
        }
        this.eventList.setMinimum(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(DataInputStream stream) throws IOException {
        long start = System.currentTimeMillis();
        byte[] bytes = new byte[stream.readInt()];
        stream.readFully(bytes);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        long read = System.currentTimeMillis();
        Pool pool = this;
        synchronized (pool) {
            long locked = System.currentTimeMillis();
            if (this.initialized) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("reading bootstrap state");
            }
            this.time = in.readInt();
            this.members.init(in);
            long membersDone = System.currentTimeMillis();
            this.elections.init(in);
            int nrOfSignals = in.readInt();
            if (nrOfSignals < 0) {
                throw new IOException("negative number of signals");
            }
            ArrayList<Event> signals = new ArrayList<Event>();
            for (int i = 0; i < nrOfSignals; ++i) {
                signals.add(new Event(in));
            }
            this.closed = in.readBoolean();
            if (this.closed) {
                this.closeEvent = new Event(in);
            }
            this.terminated = in.readBoolean();
            if (this.terminated) {
                this.terminateEvent = new Event(in);
            }
            TreeSet<Event> events = new TreeSet<Event>();
            events.addAll(this.members.getJoinEvents());
            events.addAll(this.elections.getEvents());
            events.addAll(signals);
            if (this.closed) {
                events.add(this.closeEvent);
            }
            if (this.terminated) {
                events.add(this.terminateEvent);
            }
            long used = System.currentTimeMillis();
            for (Event event : events) {
                this.registry.handleEvent(event);
            }
            long handled = System.currentTimeMillis();
            this.initialized = true;
            this.notifyAll();
            if (this.statistics != null) {
                this.statistics.newPoolSize(this.members.size());
            }
            long statted = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("pool init, read = " + (read - start) + ", locked = " + (locked - read) + ", membersDone = " + (membersDone - locked) + ", used = " + (used - membersDone) + ", handled = " + (handled - used) + ", statted = " + (statted - handled));
            }
        }
        this.handleEvents();
        if (logger.isDebugEnabled()) {
            logger.debug("bootstrap complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeState(DataOutputStream out, int joinTime) throws IOException {
        ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(arrayOut);
        Pool pool = this;
        synchronized (pool) {
            if (!this.initialized) {
                throw new IOException("state not initialized yet");
            }
            dataOut.writeInt(this.time);
            this.members.writeTo(dataOut);
            this.elections.writeTo(dataOut);
            Event[] signals = this.eventList.getSignalEvents(joinTime, this.time);
            dataOut.writeInt(signals.length);
            for (Event event : signals) {
                event.writeTo(dataOut);
            }
            dataOut.writeBoolean(this.closed);
            if (this.closed) {
                this.closeEvent.writeTo(out);
            }
            dataOut.writeBoolean(this.terminated);
            if (this.terminated) {
                this.terminateEvent.writeTo(out);
            }
        }
        dataOut.flush();
        dataOut.close();
        byte[] bytes = arrayOut.toByteArray();
        out.writeInt(bytes.length);
        out.write(bytes);
        if (logger.isDebugEnabled()) {
            logger.debug("pool state size = " + bytes.length);
        }
    }

    synchronized String[] wonElections(ibis.ipl.impl.IbisIdentifier id) {
        ArrayList<String> result = new ArrayList<String>();
        for (Election e : this.elections) {
            if (!e.getWinner().equals((Object)id)) continue;
            result.add(e.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    synchronized ibis.ipl.impl.IbisIdentifier getElectionResult(String election, long timeout) throws IOException {
        long deadline = System.currentTimeMillis() + timeout;
        if (timeout == 0L) {
            deadline = Long.MAX_VALUE;
        }
        Election result = this.elections.get(election);
        while (result == null) {
            long timeRemaining = deadline - System.currentTimeMillis();
            if (timeRemaining <= 0L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("getElectionResult deadline expired");
                }
                return null;
            }
            try {
                if (timeRemaining > 1000L) {
                    timeRemaining = 1000L;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("waiting " + timeRemaining + " for election");
                }
                this.wait(timeRemaining);
                if (logger.isDebugEnabled()) {
                    logger.debug("DONE waiting " + timeRemaining + " for election");
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            result = this.elections.get(election);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getElection result = " + result);
        }
        return result.getWinner();
    }

    private synchronized void handleEvent(Event event) {
        if (logger.isDebugEnabled()) {
            logger.debug("handling event: " + event);
        }
        switch (event.getType()) {
            case 0: {
                this.members.add(new Member(event.getIbis(), event));
                if (this.statistics == null) break;
                this.statistics.newPoolSize(this.members.size());
                break;
            }
            case 1: {
                this.members.remove(event.getIbis());
                if (this.statistics == null) break;
                this.statistics.newPoolSize(this.members.size());
                break;
            }
            case 2: {
                ibis.ipl.impl.IbisIdentifier died = event.getIbis();
                this.members.remove(died);
                if (this.statistics != null) {
                    this.statistics.newPoolSize(this.members.size());
                }
                if (!died.equals((Object)this.registry.getIbisIdentifier())) break;
                if (logger.isDebugEnabled()) {
                    logger.debug("we were declared dead");
                }
                this.stop();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.elections.put(new Election(event));
                if (this.statistics == null) break;
                this.statistics.electionEvent();
                break;
            }
            case 5: {
                this.elections.remove(event.getDescription());
                if (this.statistics == null) break;
                this.statistics.electionEvent();
                break;
            }
            case 6: {
                this.closed = true;
                this.closeEvent = event;
                break;
            }
            case 7: {
                this.terminated = true;
                this.terminateEvent = event;
                break;
            }
            default: {
                logger.error("unknown event type: " + event.getType());
            }
        }
        this.notifyAll();
        if (logger.isDebugEnabled()) {
            logger.debug("member list now: " + this.members);
        }
    }

    synchronized boolean isClosed() {
        if (!this.closedWorld) {
            throw new IbisConfigurationException("isClosed() called but not closed world");
        }
        return this.closed;
    }

    synchronized void waitUntilPoolClosed() {
        if (!this.closedWorld) {
            throw new IbisConfigurationException("waitUntilPoolClosed() called but not closed world");
        }
        while (!this.closed && !this.stopped) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void waitForEventTime(int time, long timeout) {
        long deadline = System.currentTimeMillis() + timeout;
        if (timeout == 0L) {
            deadline = Long.MAX_VALUE;
        }
        while (this.getTime() < time) {
            if (this.stopped) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime >= deadline) {
                return;
            }
            try {
                this.wait(deadline - currentTime);
            }
            catch (InterruptedException e) {}
        }
    }

    synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
        if (this.statistics != null) {
            this.statistics.newPoolSize(0);
            this.statistics.write();
        }
    }

    private synchronized Event getEvent() {
        return this.eventList.get(this.time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEvents() {
        if (logger.isDebugEnabled()) {
            logger.debug("handling events");
        }
        if (!this.isInitialized()) {
            if (logger.isDebugEnabled()) {
                logger.debug("handle events: not initialized yet");
            }
            return;
        }
        while (true) {
            Pool pool = this;
            synchronized (pool) {
                Event event = this.getEvent();
                if (event == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("done handling events, event time now: " + this.time);
                    }
                    return;
                }
                this.handleEvent(event);
                ++this.time;
                this.notifyAll();
                this.registry.handleEvent(event);
            }
        }
    }

    public synchronized Member[] getChildren() {
        return this.members.getChildren(this.registry.getIbisIdentifier());
    }

    synchronized boolean hasTerminated() {
        return this.terminated;
    }

    synchronized IbisIdentifier waitUntilTerminated() {
        while (!this.terminated && !this.stopped) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.terminateEvent != null) {
            return this.terminateEvent.getIbis();
        }
        return null;
    }
}

