/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central;

import ibis.io.IbisSerializationInputStream;
import ibis.io.IbisSerializationOutputStream;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.registry.central.Event;
import ibis.ipl.registry.central.Member;
import ibis.ipl.registry.central.MemberSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeMemberSet
implements MemberSet,
Serializable,
ibis.io.Serializable {
    private Node lastSearchResult;
    private ArrayList<Node> list;
    private static final Logger logger = LoggerFactory.getLogger(TreeMemberSet.class);
    private int nextNodeIndex;
    private final Random random;
    private ArrayList<Node> root;
    private static final long serialVersionUID = 1L;
    private SortedSet<Node> spares;

    public TreeMemberSet() {
        this.nextNodeIndex = 0;
        this.root = new ArrayList();
        this.list = new ArrayList();
        this.spares = new TreeSet<Node>();
        this.random = new Random();
    }

    @Override
    public void init(DataInputStream in) throws IOException {
        long start = System.currentTimeMillis();
        logger.debug("initializing tree member set");
        int size = in.readInt();
        logger.debug("reading  " + size + " bytes");
        byte[] data = new byte[size];
        in.readFully(data);
        long read = System.currentTimeMillis();
        ObjectInputStream objectInput = new ObjectInputStream(new ByteArrayInputStream(data));
        long stream = System.currentTimeMillis();
        try {
            this.root = (ArrayList)objectInput.readObject();
            this.list = (ArrayList)objectInput.readObject();
            this.spares = (SortedSet)objectInput.readObject();
            this.nextNodeIndex = objectInput.readInt();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("could not deserialize data for tree");
        }
        objectInput.close();
        long done = System.currentTimeMillis();
        logger.debug("TreeMemberSet.init(): read = " + (read - start) + ", stream = " + (stream - read) + ", done = " + (done - stream));
        if (logger.isDebugEnabled()) {
            logger.debug("initialized tree member set, content:" + this.toString());
        }
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        logger.debug("writing tree member set to stream");
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(byteStream);
        objectOutput.writeObject(this.root);
        objectOutput.writeObject(this.list);
        objectOutput.writeObject(this.spares);
        objectOutput.writeInt(this.nextNodeIndex);
        objectOutput.flush();
        objectOutput.close();
        logger.debug("writing " + byteStream.size() + " bytes");
        byte[] bytes = byteStream.toByteArray();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    private Node createTree(int order, SortedSet<Node> spares) {
        logger.debug("creating tree of order " + order);
        Node result = new Node(this);
        spares.add(result);
        result.children = new Node[order];
        for (int i = 0; i < order; ++i) {
            result.children[i] = this.createTree(i, spares);
        }
        return result;
    }

    private int getNextIndex() {
        return this.nextNodeIndex++;
    }

    private void expandTree() {
        int order = this.root.size();
        logger.debug("expanding tree with order " + order + " subtree");
        Node newTree = this.createTree(order, this.spares);
        this.root.add(newTree);
    }

    @Override
    public void add(Member member) {
        if (logger.isDebugEnabled()) {
            logger.debug("adding " + member + " to tree");
        }
        if (this.spares.isEmpty()) {
            this.expandTree();
        }
        Node node = this.spares.first();
        this.spares.remove(node);
        node.member = member;
        this.list.add(node);
        if (logger.isDebugEnabled()) {
            logger.debug("" + this);
        }
    }

    @Override
    public Member remove(IbisIdentifier identifier) {
        if (logger.isDebugEnabled()) {
            logger.debug("removing " + identifier + " from tree");
        }
        for (int i = 0; i < this.list.size(); ++i) {
            Node node = this.list.get(i);
            if (!node.member.getIbis().equals((Object)identifier)) continue;
            Member result = node.member;
            node.member = null;
            this.list.remove(i);
            this.spares.add(node);
            if (logger.isDebugEnabled()) {
                logger.debug("removed " + result + " from tree, result " + this);
            }
            return result;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("could not remove " + identifier + ", not found in tree");
        }
        return null;
    }

    @Override
    public Member[] asArray() {
        Member[] result = new Member[this.list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.list.get((int)i).member;
        }
        return result;
    }

    @Override
    public boolean contains(IbisIdentifier identifier) {
        for (Node node : this.list) {
            if (!node.member.getIbis().equals((Object)identifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Member member) {
        for (Node node : this.list) {
            if (!node.member.getIbis().equals((Object)member.getIbis())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Member get(IbisIdentifier identifier) {
        for (Node node : this.list) {
            if (!node.member.getIbis().equals((Object)identifier)) continue;
            return node.member;
        }
        return null;
    }

    @Override
    public Member get(String name) {
        for (Node node : this.list) {
            if (!node.member.getIbis().name().equals(name)) continue;
            return node.member;
        }
        return null;
    }

    private Node getNode(IbisIdentifier identifier) {
        for (Node node : this.list) {
            if (!node.member.getIbis().equals((Object)identifier)) continue;
            return node;
        }
        return null;
    }

    @Override
    public Member get(int index) {
        return this.list.get((int)index).member;
    }

    @Override
    public List<Event> getJoinEvents() {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Node node : this.list) {
            result.add(node.member.getEvent());
        }
        return result;
    }

    @Override
    public Member getLeastRecentlySeen() {
        if (this.list.isEmpty()) {
            return null;
        }
        Member oldest = this.list.get((int)0).member;
        for (int i = 1; i < this.list.size(); ++i) {
            if (this.list.get((int)i).member.getTime() >= oldest.getTime()) continue;
            oldest = this.list.get((int)i).member;
        }
        return oldest;
    }

    @Override
    public int getMinimumTime() {
        if (this.list.isEmpty()) {
            return -1;
        }
        int minimum = this.list.get((int)0).member.getCurrentTime();
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get((int)i).member.getCurrentTime() >= minimum) continue;
            minimum = this.list.get((int)i).member.getCurrentTime();
        }
        return minimum;
    }

    @Override
    public Member getRandom() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get((int)this.random.nextInt((int)this.size())).member;
    }

    @Override
    public Member[] getRandom(int size) {
        ArrayList<Member> result = new ArrayList<Member>();
        BitSet added = new BitSet();
        if (size > this.list.size()) {
            for (Node node : this.list) {
                result.add(node.member);
            }
            return result.toArray(new Member[0]);
        }
        while (result.size() < size) {
            int next = this.random.nextInt(this.list.size());
            if (added.get(next)) continue;
            result.add(this.list.get((int)next).member);
            added.set(next);
        }
        return result.toArray(new Member[0]);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    private void addMembers(Node node, List<Member> result) {
        if (node == null) {
            return;
        }
        if (node.member != null) {
            result.add(node.member);
            return;
        }
        for (int i = node.children.length - 1; i >= 0; --i) {
            this.addMembers(node.children[i], result);
        }
    }

    @Override
    public Member[] getChildren(IbisIdentifier ibis) {
        if (logger.isDebugEnabled()) {
            logger.debug("getting children of " + ibis);
        }
        if (this.lastSearchResult == null || this.lastSearchResult.member == null || !this.lastSearchResult.member.getIbis().equals((Object)ibis)) {
            this.lastSearchResult = this.getNode(ibis);
            if (this.lastSearchResult == null) {
                return new Member[0];
            }
        }
        ArrayList<Member> result = new ArrayList<Member>();
        for (int i = this.lastSearchResult.children.length - 1; i >= 0; --i) {
            this.addMembers(this.lastSearchResult.children[i], result);
        }
        if (logger.isDebugEnabled()) {
            String message = "children of " + ibis + ":\n";
            for (Member member : result) {
                message = message + member + "\n";
            }
            logger.debug(message);
        }
        return result.toArray(new Member[0]);
    }

    @Override
    public Member[] getRootChildren() {
        ArrayList<Member> result = new ArrayList<Member>();
        for (int i = this.root.size() - 1; i >= 0; --i) {
            this.addMembers(this.root.get(i), result);
        }
        return result.toArray(new Member[0]);
    }

    private String printTree(Node node, int level) {
        if (node == null) {
            return "";
        }
        String result = "";
        for (int i = 0; i < level; ++i) {
            result = result + "  ";
        }
        result = result + node + "\n";
        for (Node child : node.children) {
            result = result + this.printTree(child, level + 1);
        }
        return result;
    }

    public String toString() {
        String result = "\nROOT:\n";
        for (Node node : this.root) {
            result = result + this.printTree(node, 1);
        }
        result = result + "LIST:\n";
        for (Node node : this.list) {
            result = result + node + "\n";
        }
        result = result + "SPARES:\n";
        for (Node node : this.spares) {
            result = result + node + "\n";
        }
        result = result + "Children of root:\n";
        for (Member member : this.getRootChildren()) {
            result = result + member + "\n";
        }
        return result;
    }

    public final void generated_WriteObject(IbisSerializationOutputStream ibisSerializationOutputStream) throws IOException {
        ibisSerializationOutputStream.writeInt(this.nextNodeIndex);
        ibisSerializationOutputStream.writeObject((Object)this.lastSearchResult);
        ibisSerializationOutputStream.writeObject(this.list);
        ibisSerializationOutputStream.writeObject((Object)this.random);
        ibisSerializationOutputStream.writeObject(this.root);
        ibisSerializationOutputStream.writeObject(this.spares);
    }

    public final void generated_DefaultWriteObject(IbisSerializationOutputStream ibisSerializationOutputStream, int n) throws IOException {
        block0: {
            if (n != 1) break block0;
            ibisSerializationOutputStream.writeInt(this.nextNodeIndex);
            ibisSerializationOutputStream.writeObject((Object)this.lastSearchResult);
            ibisSerializationOutputStream.writeObject(this.list);
            ibisSerializationOutputStream.writeObject((Object)this.random);
            ibisSerializationOutputStream.writeObject(this.root);
            ibisSerializationOutputStream.writeObject(this.spares);
        }
    }

    public final void generated_DefaultReadObject(IbisSerializationInputStream ibisSerializationInputStream, int n) throws IOException, ClassNotFoundException {
        block0: {
            if (n != 1) break block0;
            this.nextNodeIndex = ibisSerializationInputStream.readInt();
            this.lastSearchResult = (Node)ibisSerializationInputStream.readObject();
            this.list = (ArrayList)ibisSerializationInputStream.readObject();
            ibisSerializationInputStream.readFieldObject((Object)this, "random", "ibis.ipl.registry.central.TreeMemberSet", "Ljava/util/Random;");
            this.root = (ArrayList)ibisSerializationInputStream.readObject();
            this.spares = (SortedSet)ibisSerializationInputStream.readObject();
        }
    }

    public TreeMemberSet(IbisSerializationInputStream ibisSerializationInputStream) throws IOException, ClassNotFoundException {
        ibisSerializationInputStream.addObjectToCycleCheck((Object)this);
        this.nextNodeIndex = ibisSerializationInputStream.readInt();
        this.lastSearchResult = (Node)ibisSerializationInputStream.readObject();
        this.list = (ArrayList)ibisSerializationInputStream.readObject();
        this.random = (Random)ibisSerializationInputStream.readObject();
        this.root = (ArrayList)ibisSerializationInputStream.readObject();
        this.spares = (SortedSet)ibisSerializationInputStream.readObject();
    }

    private class Node
    implements Serializable,
    Comparable<Node> {
        Node[] children;
        int index;
        Member member;
        private static final long serialVersionUID = 1L;
        final /* synthetic */ TreeMemberSet this$0;

        Node(TreeMemberSet treeMemberSet) {
            this.this$0 = treeMemberSet;
            this.index = treeMemberSet.getNextIndex();
            this.children = new Node[0];
            this.member = null;
        }

        public String toString() {
            return "node " + this.index + " member = " + this.member + " with " + this.children.length + " children";
        }

        @Override
        public int compareTo(Node o) {
            return this.index - o.index;
        }

        public void generated_WriteObject(IbisSerializationOutputStream ibisSerializationOutputStream) throws IOException {
            int n;
            ibisSerializationOutputStream.writeInt(this.index);
            ibisSerializationOutputStream.writeObject((Object)this.children);
            if (null != ibisSerializationOutputStream.replacer) {
                ibisSerializationOutputStream.writeObject((Object)this.member);
            } else {
                n = ibisSerializationOutputStream.writeKnownObjectHeader((Object)this.member);
                if (n == 1) {
                    this.member.generated_WriteObject(ibisSerializationOutputStream);
                }
            }
            if (null != ibisSerializationOutputStream.replacer) {
                ibisSerializationOutputStream.writeObject((Object)this.this$0);
            } else {
                n = ibisSerializationOutputStream.writeKnownObjectHeader((Object)this.this$0);
                if (n == 1) {
                    this.this$0.generated_WriteObject(ibisSerializationOutputStream);
                }
            }
        }

        public void generated_DefaultWriteObject(IbisSerializationOutputStream ibisSerializationOutputStream, int n) throws IOException {
            block3: {
                block4: {
                    if (n != 1) break block3;
                    ibisSerializationOutputStream.writeInt(this.index);
                    ibisSerializationOutputStream.writeObject((Object)this.children);
                    if (null != ibisSerializationOutputStream.replacer) {
                        ibisSerializationOutputStream.writeObject((Object)this.member);
                    } else {
                        n = ibisSerializationOutputStream.writeKnownObjectHeader((Object)this.member);
                        if (n == 1) {
                            this.member.generated_WriteObject(ibisSerializationOutputStream);
                        }
                    }
                    if (null == ibisSerializationOutputStream.replacer) break block4;
                    ibisSerializationOutputStream.writeObject((Object)this.this$0);
                    break block3;
                }
                n = ibisSerializationOutputStream.writeKnownObjectHeader((Object)this.this$0);
                if (n != 1) break block3;
                this.this$0.generated_WriteObject(ibisSerializationOutputStream);
            }
        }

        public void generated_DefaultReadObject(IbisSerializationInputStream ibisSerializationInputStream, int n) throws IOException, ClassNotFoundException {
            block3: {
                block4: {
                    if (n != 1) break block3;
                    this.index = ibisSerializationInputStream.readInt();
                    this.children = (Node[])ibisSerializationInputStream.readObject();
                    n = ibisSerializationInputStream.readKnownTypeHeader();
                    if (n == -1) {
                        this.member = new Member(ibisSerializationInputStream);
                    } else if (n != 0) {
                        this.member = (Member)ibisSerializationInputStream.getObjectFromCycleCheck(n);
                    }
                    n = ibisSerializationInputStream.readKnownTypeHeader();
                    if (n != -1) break block4;
                    this.this$0 = new TreeMemberSet(ibisSerializationInputStream);
                    break block3;
                }
                if (n == 0) break block3;
                this.this$0 = (TreeMemberSet)ibisSerializationInputStream.getObjectFromCycleCheck(n);
            }
        }

        public Node(IbisSerializationInputStream ibisSerializationInputStream) throws IOException, ClassNotFoundException {
            ibisSerializationInputStream.addObjectToCycleCheck((Object)this);
            this.index = ibisSerializationInputStream.readInt();
            this.children = (Node[])ibisSerializationInputStream.readObject();
            int n = ibisSerializationInputStream.readKnownTypeHeader();
            if (n == -1) {
                this.member = new Member(ibisSerializationInputStream);
            } else if (n != 0) {
                this.member = (Member)ibisSerializationInputStream.getObjectFromCycleCheck(n);
            }
            n = ibisSerializationInputStream.readKnownTypeHeader();
            if (n == -1) {
                this.this$0 = new TreeMemberSet(ibisSerializationInputStream);
            } else if (n != 0) {
                this.this$0 = (TreeMemberSet)ibisSerializationInputStream.getObjectFromCycleCheck(n);
            }
        }
    }
}

