/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central;

import ibis.io.IbisSerializationInputStream;
import ibis.io.IbisSerializationOutputStream;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.registry.central.Event;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Member
implements Serializable,
ibis.io.Serializable {
    private int currentEventTime;
    private final Event event;
    private final IbisIdentifier ibis;
    private static final Logger logger = LoggerFactory.getLogger(Member.class);
    private static final long serialVersionUID = 1L;
    private long time;

    public Member(IbisIdentifier ibis, Event event) {
        this.ibis = ibis;
        this.event = event;
        this.currentEventTime = 0;
        this.time = 0L;
    }

    public Member(DataInput in) throws IOException {
        this.ibis = new IbisIdentifier(in);
        this.event = new Event(in);
        this.currentEventTime = 0;
        this.time = 0L;
    }

    public void writeTo(DataOutput out) throws IOException {
        this.ibis.writeTo(out);
        this.event.writeTo(out);
    }

    public IbisIdentifier getIbis() {
        return this.ibis;
    }

    public synchronized int getCurrentTime() {
        return this.currentEventTime;
    }

    public synchronized void setCurrentTime(int currentTime) {
        if (currentTime < this.currentEventTime) {
            logger.error("tried to set time backwards on member. Current time = " + this.currentEventTime + " new time = " + currentTime, (Throwable)new Exception());
            return;
        }
        this.currentEventTime = currentTime;
    }

    public synchronized void updateTime() {
        this.time = System.currentTimeMillis();
    }

    public synchronized void clearTime() {
        this.time = 0L;
    }

    public synchronized long getTime() {
        return this.time;
    }

    String getID() {
        return this.ibis.getID();
    }

    public String toString() {
        return this.ibis.toString() + "@T" + this.getCurrentTime();
    }

    public Event getEvent() {
        return this.event;
    }

    public final void generated_WriteObject(IbisSerializationOutputStream ibisSerializationOutputStream) throws IOException {
        ibisSerializationOutputStream.writeInt(this.currentEventTime);
        ibisSerializationOutputStream.writeLong(this.time);
        if (null != ibisSerializationOutputStream.replacer) {
            ibisSerializationOutputStream.writeObject((Object)this.event);
        } else {
            int n = ibisSerializationOutputStream.writeKnownObjectHeader((Object)this.event);
            if (n == 1) {
                this.event.generated_WriteObject(ibisSerializationOutputStream);
            }
        }
        ibisSerializationOutputStream.writeObject((Object)this.ibis);
    }

    public final void generated_DefaultWriteObject(IbisSerializationOutputStream ibisSerializationOutputStream, int n) throws IOException {
        block3: {
            if (n != 1) break block3;
            ibisSerializationOutputStream.writeInt(this.currentEventTime);
            ibisSerializationOutputStream.writeLong(this.time);
            if (null != ibisSerializationOutputStream.replacer) {
                ibisSerializationOutputStream.writeObject((Object)this.event);
            } else {
                n = ibisSerializationOutputStream.writeKnownObjectHeader((Object)this.event);
                if (n == 1) {
                    this.event.generated_WriteObject(ibisSerializationOutputStream);
                }
            }
            ibisSerializationOutputStream.writeObject((Object)this.ibis);
        }
    }

    public final void generated_DefaultReadObject(IbisSerializationInputStream ibisSerializationInputStream, int n) throws IOException, ClassNotFoundException {
        block3: {
            if (n != 1) break block3;
            this.currentEventTime = ibisSerializationInputStream.readInt();
            this.time = ibisSerializationInputStream.readLong();
            n = ibisSerializationInputStream.readKnownTypeHeader();
            if (n == -1) {
                this.event = new Event(ibisSerializationInputStream);
            } else if (n != 0) {
                this.event = (Event)ibisSerializationInputStream.getObjectFromCycleCheck(n);
            }
            ibisSerializationInputStream.readFieldObject((Object)this, "ibis", "ibis.ipl.registry.central.Member", "Libis/ipl/impl/IbisIdentifier;");
        }
    }

    public Member(IbisSerializationInputStream ibisSerializationInputStream) throws IOException, ClassNotFoundException {
        ibisSerializationInputStream.addObjectToCycleCheck((Object)this);
        this.currentEventTime = ibisSerializationInputStream.readInt();
        this.time = ibisSerializationInputStream.readLong();
        int n = ibisSerializationInputStream.readKnownTypeHeader();
        if (n == -1) {
            this.event = new Event(ibisSerializationInputStream);
        } else if (n != 0) {
            this.event = (Event)ibisSerializationInputStream.getObjectFromCycleCheck(n);
        }
        this.ibis = (IbisIdentifier)ibisSerializationInputStream.readObject();
    }
}

